/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.base.ObjectRelationshipServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectRelationship"}, service={AopService.class})
public class ObjectRelationshipServiceImpl
extends ObjectRelationshipServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;

    public ObjectRelationship addObjectRelationship(long objectDefinitionId1, long objectDefinitionId2, long parameterObjectFieldId, String deletionType, Map<Locale, String> labelMap, String name, String type) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId1);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinition.getObjectDefinitionId(), "UPDATE");
        return this.objectRelationshipLocalService.addObjectRelationship(this.getUserId(), objectDefinitionId1, objectDefinitionId2, parameterObjectFieldId, deletionType, labelMap, name, type);
    }

    public void addObjectRelationshipMappingTableValues(long objectRelationshipId, long primaryKey1, long primaryKey2, ServiceContext serviceContext) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectRelationship.getObjectDefinitionId1(), "UPDATE");
        this.objectRelationshipLocalService.addObjectRelationshipMappingTableValues(this.getUserId(), objectRelationshipId, primaryKey1, primaryKey2, serviceContext);
    }

    public ObjectRelationship deleteObjectRelationship(long objectRelationshipId) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectRelationship.getObjectDefinitionId1(), "UPDATE");
        return this.objectRelationshipLocalService.deleteObjectRelationship(objectRelationshipId);
    }

    public ObjectRelationship getObjectRelationship(long objectRelationshipId) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectRelationship.getObjectDefinitionId1(), "VIEW");
        return this.objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
    }

    public ObjectRelationship getObjectRelationship(long objectDefinitionId1, String name) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId1, "VIEW");
        return this.objectRelationshipPersistence.findByODI1_N(objectDefinitionId1, name);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, int start, int end) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId1);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinition.getObjectDefinitionId(), "VIEW");
        return this.objectRelationshipLocalService.getObjectRelationships(objectDefinitionId1, start, end);
    }

    public ObjectRelationship updateObjectRelationship(long objectRelationshipId, long parameterObjectFieldId, String deletionType, Map<Locale, String> labelMap) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectRelationship.getObjectDefinitionId1(), "UPDATE");
        return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationshipId, parameterObjectFieldId, deletionType, labelMap);
    }
}

