/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedException;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedObjectFieldIdException;
import com.liferay.object.exception.ObjectDefinitionActiveException;
import com.liferay.object.exception.ObjectDefinitionLabelException;
import com.liferay.object.exception.ObjectDefinitionNameException;
import com.liferay.object.exception.ObjectDefinitionPluralLabelException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectDefinitionStatusException;
import com.liferay.object.exception.ObjectDefinitionVersionException;
import com.liferay.object.exception.ObjectFieldRelationshipTypeException;
import com.liferay.object.exception.RequiredObjectDefinitionException;
import com.liferay.object.exception.RequiredObjectFieldException;
import com.liferay.object.internal.deployer.ObjectDefinitionDeployerImpl;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.impl.ObjectDefinitionImpl;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectLayoutLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.service.base.ObjectDefinitionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.util.LocalizedMapUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchRegistrarHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(property={"model.class.name=com.liferay.object.model.ObjectDefinition"}, service={AopService.class})
public class ObjectDefinitionLocalServiceImpl
extends ObjectDefinitionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDefinitionLocalServiceImpl.class);
    private static final MethodKey _deployObjectDefinitionMethodKey = new MethodKey(ObjectDefinitionLocalServiceUtil.class, "deployObjectDefinition", new Class[]{ObjectDefinition.class});
    private static final MethodKey _undeployObjectDefinitionMethodKey = new MethodKey(ObjectDefinitionLocalServiceUtil.class, "undeployObjectDefinition", new Class[]{ObjectDefinition.class});
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    private BundleContext _bundleContext;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ModelSearchRegistrarHelper _modelSearchRegistrarHelper;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    private ServiceTracker<ObjectDefinitionDeployer, ObjectDefinitionDeployer> _objectDefinitionDeployerServiceTracker;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryPersistence _objectEntryPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectLayoutLocalService _objectLayoutLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    @Reference
    private ObjectViewLocalService _objectViewLocalService;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ResourceLocalService _resourceLocalService;
    private final Map<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> _serviceRegistrationsMaps = Collections.synchronizedMap(new LinkedHashMap());
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    private ModelPreFilterContributor _workflowStatusModelPreFilterContributor;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addCustomObjectDefinition(long userId, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, String scope, String storageType, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(userId, null, null, labelMap, name, panelAppOrder, panelCategoryKey, null, null, pluralLabelMap, scope, storageType, false, 0, 2, objectFields);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addOrUpdateSystemObjectDefinition(long companyId, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, systemObjectDefinitionMetadata.getName());
        if (objectDefinition != null && objectDefinition.getVersion() == systemObjectDefinitionMetadata.getVersion()) {
            return objectDefinition;
        }
        long userId = this._userLocalService.getDefaultUserId(companyId);
        if (objectDefinition == null) {
            Table table = systemObjectDefinitionMetadata.getTable();
            Column primaryKeyColumn = systemObjectDefinitionMetadata.getPrimaryKeyColumn();
            return this.addSystemObjectDefinition(userId, systemObjectDefinitionMetadata.getModelClassName(), table.getTableName(), systemObjectDefinitionMetadata.getLabelMap(), systemObjectDefinitionMetadata.getName(), primaryKeyColumn.getName(), primaryKeyColumn.getName(), systemObjectDefinitionMetadata.getPluralLabelMap(), systemObjectDefinitionMetadata.getScope(), systemObjectDefinitionMetadata.getVersion(), systemObjectDefinitionMetadata.getObjectFields());
        }
        objectDefinition.setVersion(systemObjectDefinitionMetadata.getVersion());
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        List newObjectFields = systemObjectDefinitionMetadata.getObjectFields();
        List oldObjectFields = this._objectFieldPersistence.findByODI_DTN(objectDefinition.getObjectDefinitionId(), objectDefinition.getDBTableName());
        for (ObjectField oldObjectField : oldObjectFields) {
            if (this._hasObjectField(newObjectFields, oldObjectField)) continue;
            this._objectFieldPersistence.remove((BaseModel)oldObjectField);
        }
        for (ObjectField newObjectField : newObjectFields) {
            ObjectField oldObjectField = this._objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), newObjectField.getName());
            if (oldObjectField == null) {
                this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), newObjectField.getBusinessType(), newObjectField.getDBColumnName(), objectDefinition.getDBTableName(), newObjectField.getDBType(), newObjectField.getDefaultValue(), false, false, "", newObjectField.getLabelMap(), newObjectField.getName(), newObjectField.isRequired(), newObjectField.isState());
                continue;
            }
            if (Objects.equals(oldObjectField, newObjectField.getDBType())) continue;
            oldObjectField.setBusinessType(newObjectField.getBusinessType());
            oldObjectField.setDBType(newObjectField.getDBType());
            oldObjectField.setRequired(newObjectField.isRequired());
            this._objectFieldPersistence.update((BaseModel)oldObjectField);
        }
        return objectDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addSystemObjectDefinition(long userId, String className, String dbTableName, Map<Locale, String> labelMap, String name, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope, int version, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(userId, className, dbTableName, labelMap, name, null, null, pkObjectFieldDBColumnName, pkObjectFieldName, pluralLabelMap, scope, "default", true, version, 0, objectFields);
    }

    public void deleteCompanyObjectDefinitions(long companyId) throws PortalException {
        List objectDefinitions = this.objectDefinitionPersistence.findByCompanyId(companyId);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this.objectDefinitionLocalService.deleteObjectDefinition(objectDefinition);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectDefinition deleteObjectDefinition(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this.deleteObjectDefinition(objectDefinition);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectDefinition deleteObjectDefinition(ObjectDefinition objectDefinition) throws PortalException {
        if (!CompanyThreadLocal.isDeleteInProcess() && !PortalRunMode.isTestMode() && objectDefinition.isSystem()) {
            throw new RequiredObjectDefinitionException();
        }
        this._objectActionLocalService.deleteObjectActions(objectDefinition.getObjectDefinitionId());
        if (!objectDefinition.isSystem()) {
            List objectEntries = this._objectEntryPersistence.findByObjectDefinitionId(objectDefinition.getObjectDefinitionId());
            for (ObjectEntry objectEntry : objectEntries) {
                this._objectEntryLocalService.deleteObjectEntry(objectEntry);
            }
        }
        this._objectFieldLocalService.deleteObjectFieldByObjectDefinitionId(Long.valueOf(objectDefinition.getObjectDefinitionId()));
        this._objectLayoutLocalService.deleteObjectLayouts(objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : this._objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinition.getObjectDefinitionId())) {
            this._objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
        for (ObjectRelationship objectRelationship : this._objectRelationshipPersistence.findByObjectDefinitionId2(objectDefinition.getObjectDefinitionId())) {
            this._objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
        this._objectValidationRuleLocalService.deleteObjectValidationRules(Long.valueOf(objectDefinition.getObjectDefinitionId()));
        this._objectViewLocalService.deleteObjectViews(objectDefinition.getObjectDefinitionId());
        this.objectDefinitionPersistence.remove((BaseModel)objectDefinition);
        this._resourceLocalService.deleteResource(objectDefinition.getCompanyId(), ObjectDefinition.class.getName(), 4, objectDefinition.getObjectDefinitionId());
        if (objectDefinition.isSystem()) {
            this._dropTable(objectDefinition.getExtensionDBTableName());
        } else if (objectDefinition.isApproved()) {
            for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getClassName())) {
                this._resourceActionLocalService.deleteResourceAction(resourceAction);
            }
            for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getPortletId())) {
                this._resourceActionLocalService.deleteResourceAction(resourceAction);
            }
            for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getResourceName())) {
                this._resourceActionLocalService.deleteResourceAction(resourceAction);
            }
            this._dropTable(objectDefinition.getDBTableName());
            this._dropTable(objectDefinition.getExtensionDBTableName());
            this.undeployObjectDefinition(objectDefinition);
            this._registerTransactionCallbackForCluster(_undeployObjectDefinitionMethodKey, objectDefinition);
        }
        return objectDefinition;
    }

    public void deployObjectDefinition(ObjectDefinition objectDefinition) {
        if (objectDefinition.isSystem()) {
            return;
        }
        this.undeployObjectDefinition(objectDefinition);
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            serviceRegistrationsMap.computeIfAbsent(objectDefinition.getObjectDefinitionId(), objectDefinitionId -> objectDefinitionDeployer.deploy(objectDefinition));
        }
    }

    public ObjectDefinition fetchObjectDefinition(long companyId, String name) {
        return this.objectDefinitionPersistence.fetchByC_N(companyId, name);
    }

    public ObjectDefinition fetchObjectDefinitionByClassName(long companyId, String className) throws PortalException {
        return this.objectDefinitionPersistence.fetchByC_C(companyId, className);
    }

    public List<ObjectDefinition> getCustomObjectDefinitions(int status) {
        return this.objectDefinitionPersistence.findByS_S(false, status);
    }

    @Override
    public ObjectDefinition getObjectDefinition(long objectDefinitionId) throws PortalException {
        return this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, boolean active, boolean system, int status) {
        return this.objectDefinitionPersistence.findByC_A_S_S(companyId, active, system, status);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, boolean active, int status) {
        return this.objectDefinitionPersistence.findByC_A_S(companyId, active, status);
    }

    public int getObjectDefinitionsCount(long companyId) throws PortalException {
        return this.objectDefinitionPersistence.countByCompanyId(companyId);
    }

    public List<ObjectDefinition> getSystemObjectDefinitions() {
        return this.objectDefinitionPersistence.findBySystem(true);
    }

    public boolean hasObjectRelationship(long objectDefinitionId) {
        int countByObjectDefinitionId1 = this._objectRelationshipPersistence.countByObjectDefinitionId1(objectDefinitionId);
        int countByObjectDefinitionId2 = this._objectRelationshipPersistence.countByObjectDefinitionId2(objectDefinitionId);
        return countByObjectDefinitionId1 > 0 || countByObjectDefinitionId2 > 0;
    }

    public ObjectDefinition publishCustomObjectDefinition(long userId, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isSystem()) {
            throw new ObjectDefinitionStatusException();
        }
        int count = this._objectFieldPersistence.countByODI_S(objectDefinition.getObjectDefinitionId(), false);
        if (count == 0) {
            throw new RequiredObjectFieldException();
        }
        objectDefinition.setActive(true);
        objectDefinition.setStatus(0);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._createTable(objectDefinition.getDBTableName(), objectDefinition);
        this._createTable(objectDefinition.getExtensionDBTableName(), objectDefinition);
        this.deployObjectDefinition(objectDefinition);
        this._registerTransactionCallbackForCluster(_deployObjectDefinitionMethodKey, objectDefinition);
        return objectDefinition;
    }

    @Override
    public void setAopProxy(Object aopProxy) {
        super.setAopProxy(aopProxy);
        this._addingObjectDefinitionDeployer(new ObjectDefinitionDeployerImpl(this._assetCategoryLocalService, this._assetTagLocalService, this._assetVocabularyLocalService, this._bundleContext, this._dynamicQueryBatchIndexingActionableFactory, this._groupLocalService, this._listTypeEntryLocalService, this._modelSearchRegistrarHelper, this, this._objectEntryLocalService, this._objectFieldLocalService, this._objectLayoutLocalService, this._objectRelationshipLocalService, this._objectScopeProviderRegistry, this._objectViewLocalService, this._persistedModelLocalServiceRegistry, this._resourceActions, this._userLocalService, this._workflowStatusModelPreFilterContributor));
        this._objectDefinitionDeployerServiceTracker = new ServiceTracker(this._bundleContext, ObjectDefinitionDeployer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ObjectDefinitionDeployer, ObjectDefinitionDeployer>(){

            public ObjectDefinitionDeployer addingService(ServiceReference<ObjectDefinitionDeployer> serviceReference) {
                return ObjectDefinitionLocalServiceImpl.this._addingObjectDefinitionDeployer((ObjectDefinitionDeployer)ObjectDefinitionLocalServiceImpl.this._bundleContext.getService(serviceReference));
            }

            public void modifiedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
            }

            public void removedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
                Map serviceRegistrationsMap = (Map)ObjectDefinitionLocalServiceImpl.this._serviceRegistrationsMaps.remove(objectDefinitionDeployer);
                for (List serviceRegistrations : serviceRegistrationsMap.values()) {
                    for (ServiceRegistration serviceRegistration : serviceRegistrations) {
                        serviceRegistration.unregister();
                    }
                }
                ObjectDefinitionLocalServiceImpl.this._bundleContext.ungetService(serviceReference);
            }
        });
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            this._objectDefinitionDeployerServiceTracker.open();
            return null;
        });
    }

    public void undeployObjectDefinition(ObjectDefinition objectDefinition) {
        if (objectDefinition.isSystem()) {
            return;
        }
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            objectDefinitionDeployer.undeploy(objectDefinition);
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            List<ServiceRegistration<?>> serviceRegistrations = serviceRegistrationsMap.remove(objectDefinition.getObjectDefinitionId());
            if (serviceRegistrations == null) continue;
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
        this._invalidatePortalCache(objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateCustomObjectDefinition(long objectDefinitionId, long accountEntryRestrictedObjectFieldId, long descriptionObjectFieldId, long titleObjectFieldId, boolean accountEntryRestricted, boolean active, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, boolean portlet, Map<Locale, String> pluralLabelMap, String scope) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isSystem()) {
            throw new ObjectDefinitionStatusException("Object definition " + objectDefinition);
        }
        return this._updateObjectDefinition(objectDefinition, accountEntryRestrictedObjectFieldId, descriptionObjectFieldId, titleObjectFieldId, accountEntryRestricted, active, null, labelMap, name, panelAppOrder, panelCategoryKey, portlet, null, null, pluralLabelMap, scope);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateTitleObjectFieldId(long objectDefinitionId, long titleObjectFieldId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        if (this._objectDefinitionDeployerServiceTracker != null) {
            this._objectDefinitionDeployerServiceTracker.close();
        }
    }

    private ObjectDefinitionDeployer _addingObjectDefinitionDeployer(ObjectDefinitionDeployer objectDefinitionDeployer) {
        ConcurrentHashMap serviceRegistrationsMap = new ConcurrentHashMap();
        this._companyLocalService.forEachCompanyId(companyId -> {
            List objectDefinitions = this.objectDefinitionLocalService.getObjectDefinitions(companyId.longValue(), true, false, 0);
            for (ObjectDefinition objectDefinition : objectDefinitions) {
                serviceRegistrationsMap.put(objectDefinition.getObjectDefinitionId(), objectDefinitionDeployer.deploy(objectDefinition));
            }
        });
        this._serviceRegistrationsMaps.put(objectDefinitionDeployer, serviceRegistrationsMap);
        return objectDefinitionDeployer;
    }

    private ObjectDefinition _addObjectDefinition(long userId, String className, String dbTableName, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope, String storageType, boolean system, int version, int status, List<ObjectField> objectFields) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        name = this._getName(name, system);
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, name, system, user.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, system, shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, system);
        this._validateLabel(labelMap);
        this._validateName(0L, user.getCompanyId(), name, system);
        this._validatePluralLabel(pluralLabelMap);
        this._validateScope(scope);
        this._validateVersion(system, version);
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.create(this.counterLocalService.increment());
        objectDefinition.setCompanyId(user.getCompanyId());
        objectDefinition.setUserId(user.getUserId());
        objectDefinition.setUserName(user.getFullName());
        objectDefinition.setActive(system);
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setClassName(this._getClassName(objectDefinition.getObjectDefinitionId(), className, system));
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setName(name);
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        objectDefinition.setScope(scope);
        objectDefinition.setStorageType(Validator.isNotNull((String)storageType) ? storageType : "default");
        objectDefinition.setSystem(system);
        objectDefinition.setVersion(version);
        objectDefinition.setStatus(status);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._resourceLocalService.addResources(objectDefinition.getCompanyId(), 0L, objectDefinition.getUserId(), ObjectDefinition.class.getName(), objectDefinition.getObjectDefinitionId(), false, true, true);
        if (!objectDefinition.isSystem()) {
            dbTableName = "ObjectEntry";
        }
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.userName.getName(), dbTableName, "String", null, false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "author")), "creator", false, false);
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Date", ObjectEntryTable.INSTANCE.createDate.getName(), dbTableName, "Date", null, false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "create-date")), "createDate", false, false);
        String dbColumnName = ObjectEntryTable.INSTANCE.objectEntryId.getName();
        if (system) {
            dbColumnName = pkObjectFieldName;
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-158821")) && !objectDefinition.isSystem()) {
            this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.externalReferenceCode.getName(), ObjectEntryTable.INSTANCE.getTableName(), "String", null, false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "external-reference-code")), "externalReferenceCode", false, false);
        }
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "LongInteger", dbColumnName, dbTableName, "Long", null, false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "id")), "id", false, false);
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Date", ObjectEntryTable.INSTANCE.modifiedDate.getName(), dbTableName, "Date", null, false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "modified-date")), "modifiedDate", false, false);
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.status.getName(), dbTableName, "Integer", null, false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "status")), "status", false, false);
        if (objectFields != null) {
            for (ObjectField objectField : objectFields) {
                if (system || objectField.isSystem()) {
                    this._objectFieldLocalService.addOrUpdateSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), objectField.getBusinessType(), objectField.getDBColumnName(), objectDefinition.getDBTableName(), objectField.getDBType(), objectField.getDefaultValue(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.getName(), objectField.isRequired(), objectField.isState());
                    continue;
                }
                this._objectFieldLocalService.addCustomObjectField(userId, objectField.getListTypeDefinitionId(), objectDefinition.getObjectDefinitionId(), objectField.getBusinessType(), objectField.getDBType(), objectField.getDefaultValue(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.getName(), objectField.isRequired(), objectField.isState(), objectField.getObjectFieldSettings());
            }
        }
        if (system) {
            this._createTable(objectDefinition.getExtensionDBTableName(), objectDefinition);
        }
        return objectDefinition;
    }

    private void _createTable(String dbTableName, ObjectDefinition objectDefinition) {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldPersistence.findByODI_DTN(objectDefinition.getObjectDefinitionId(), dbTableName), dbTableName);
        this.runSQL(dynamicObjectDefinitionTable.getCreateTableSQL());
    }

    private void _dropTable(String dbTableName) {
        String sql = "drop table " + dbTableName;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        this.runSQL(sql);
    }

    private String _getClassName(long objectDefinitionId, String className, boolean system) {
        if (system) {
            return className;
        }
        return "com.liferay.object.model.ObjectDefinition#" + objectDefinitionId;
    }

    private String _getDBTableName(String dbTableName, String name, boolean system, Long companyId, String shortName) {
        if (Validator.isNotNull((String)dbTableName)) {
            return dbTableName;
        }
        if (system) {
            return name;
        }
        return StringBundler.concat((Object[])new Object[]{"O_", companyId, "_", shortName});
    }

    private String _getName(String name, boolean system) {
        name = StringUtil.trim((String)name);
        if (!system) {
            name = "C_" + name;
        }
        return name;
    }

    private String _getPKObjectFieldDBColumnName(String pkObjectFieldDBColumnName, String pkObjectFieldName, boolean system) {
        if (Validator.isNotNull((String)pkObjectFieldDBColumnName)) {
            return pkObjectFieldDBColumnName;
        }
        if (system) {
            return pkObjectFieldName;
        }
        return pkObjectFieldName + "_";
    }

    private String _getPKObjectFieldName(String pkObjectFieldName, boolean system, String shortName) {
        if (Validator.isNotNull((String)pkObjectFieldName)) {
            return pkObjectFieldName;
        }
        pkObjectFieldName = TextFormatter.format((String)(shortName + "Id"), (int)8);
        if (system) {
            return pkObjectFieldName;
        }
        pkObjectFieldName = "c_" + pkObjectFieldName;
        return pkObjectFieldName;
    }

    private boolean _hasObjectField(List<ObjectField> newObjectFields, ObjectField oldObjectField) {
        for (ObjectField newObjectField : newObjectFields) {
            if (!Objects.equals(newObjectField.getName(), oldObjectField.getName())) continue;
            return true;
        }
        return false;
    }

    private void _invalidatePortalCache(ObjectDefinition objectDefinition) {
        PortalCache portalCache = this._multiVMPool.getPortalCache(FragmentEntryLink.class.getName());
        List layoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsages(objectDefinition.getCompanyId(), this._classNameLocalService.getClassNameId(objectDefinition.getClassName()), this._portal.getClassNameId(FragmentEntryLink.class));
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            Set availableLocales = this._language.getAvailableLocales(layoutClassedModelUsage.getGroupId());
            for (Locale locale : availableLocales) {
                portalCache.remove((Serializable)((Object)StringBundler.concat((Object[])new Object[]{layoutClassedModelUsage.getContainerKey(), "-", locale, "-", 0})));
            }
        }
    }

    private void _registerTransactionCallbackForCluster(MethodKey methodKey, ObjectDefinition objectDefinition) {
        if (ClusterExecutorUtil.isEnabled()) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(methodKey, new Object[]{objectDefinition}), (boolean)true);
                clusterRequest.setFireAndForget(true);
                ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
                return null;
            });
        }
    }

    private ObjectDefinition _updateObjectDefinition(ObjectDefinition objectDefinition, long accountEntryRestrictedObjectFieldId, long descriptionObjectFieldId, long titleObjectFieldId, boolean accountEntryRestricted, boolean active, String dbTableName, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, boolean portlet, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope) throws PortalException {
        boolean originalActive = objectDefinition.isActive();
        this._validateAccountEntryRestrictedObjectFieldId(accountEntryRestrictedObjectFieldId, accountEntryRestricted, objectDefinition);
        this._validateObjectFieldId(objectDefinition, descriptionObjectFieldId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        this._validateActive(objectDefinition, active);
        this._validateLabel(labelMap);
        this._validatePluralLabel(pluralLabelMap);
        if (objectDefinition.getAccountEntryRestrictedObjectFieldId() != 0L) {
            this._objectFieldLocalService.updateRequired(objectDefinition.getAccountEntryRestrictedObjectFieldId(), false);
        }
        if (accountEntryRestricted && accountEntryRestrictedObjectFieldId > 0L) {
            this._objectFieldLocalService.updateRequired(accountEntryRestrictedObjectFieldId, true);
        }
        objectDefinition.setAccountEntryRestrictedObjectFieldId(accountEntryRestrictedObjectFieldId);
        objectDefinition.setDescriptionObjectFieldId(descriptionObjectFieldId);
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        objectDefinition.setAccountEntryRestricted(accountEntryRestricted);
        objectDefinition.setActive(active);
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setPortlet(portlet);
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        if (objectDefinition.isApproved()) {
            if (!active && originalActive) {
                this.objectDefinitionLocalService.undeployObjectDefinition(objectDefinition);
            } else if (active) {
                this.objectDefinitionLocalService.deployObjectDefinition(objectDefinition);
            }
            if (active != originalActive) {
                this._updateWorkflowInstances(objectDefinition);
            }
            return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        name = this._getName(name, objectDefinition.isSystem());
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, name, objectDefinition.isSystem(), objectDefinition.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, objectDefinition.isSystem(), shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, objectDefinition.isSystem());
        this._validateName(objectDefinition.getObjectDefinitionId(), objectDefinition.getCompanyId(), name, objectDefinition.isSystem());
        this._validateScope(scope);
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setName(name);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setScope(scope);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    private void _updateWorkflowInstances(ObjectDefinition objectDefinition) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._objectEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property objectDefinitionIdProperty = PropertyFactoryUtil.forName((String)"objectDefinitionId");
            dynamicQuery.add(objectDefinitionIdProperty.eq((Object)objectDefinition.getObjectDefinitionId()));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.ne((Object)0));
        });
        actionableDynamicQuery.setParallel(true);
        actionableDynamicQuery.setPerformActionMethod(objectEntry -> {
            WorkflowInstanceLink workflowInstanceLink = this._workflowInstanceLinkLocalService.fetchWorkflowInstanceLink(objectEntry.getCompanyId(), objectEntry.getNonzeroGroupId(), objectDefinition.getClassName(), objectEntry.getObjectEntryId());
            if (workflowInstanceLink != null) {
                this._workflowInstanceManager.updateActive(objectDefinition.getUserId(), objectDefinition.getCompanyId(), workflowInstanceLink.getWorkflowInstanceId(), objectDefinition.isActive());
            }
        });
        actionableDynamicQuery.performActions();
    }

    private void _validateAccountEntryRestrictedObjectFieldId(long accountEntryRestrictedObjectFieldId, boolean accountEntryRestricted, ObjectDefinition objectDefinition) throws ObjectDefinitionAccountEntryRestrictedException, ObjectDefinitionAccountEntryRestrictedObjectFieldIdException {
        if (accountEntryRestricted && accountEntryRestrictedObjectFieldId == 0L) {
            throw new ObjectDefinitionAccountEntryRestrictedObjectFieldIdException();
        }
        if (objectDefinition.isApproved() && (accountEntryRestricted != objectDefinition.isAccountEntryRestricted() || accountEntryRestrictedObjectFieldId != objectDefinition.getAccountEntryRestrictedObjectFieldId())) {
            throw new ObjectDefinitionAccountEntryRestrictedException("Account entry restrictions on approved object definitions cannot be changed");
        }
    }

    private void _validateActive(ObjectDefinition objectDefinition, boolean active) throws PortalException {
        if (active && !objectDefinition.isApproved()) {
            throw new ObjectDefinitionActiveException("Object definitions must be published before being activated");
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectDefinitionLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateName(long objectDefinitionId, long companyId, String name, boolean system) throws PortalException {
        if (Validator.isNull((String)name) || !system && name.equals("C_")) {
            throw new ObjectDefinitionNameException.MustNotBeNull();
        }
        if (system && (name.startsWith("C_") || name.startsWith("c_"))) {
            throw new ObjectDefinitionNameException.MustNotStartWithCAndUnderscoreForSystemObject();
        }
        if (!system && !name.startsWith("C_")) {
            throw new ObjectDefinitionNameException.MustStartWithCAndUnderscoreForCustomObject();
        }
        char[] nameCharArray = name.toCharArray();
        for (int i = 0; i < nameCharArray.length; ++i) {
            char c;
            if (!system && (i == 0 || i == 1) || Validator.isChar((char)(c = nameCharArray[i])) || Validator.isDigit((char)c)) continue;
            throw new ObjectDefinitionNameException.MustOnlyContainLettersAndDigits();
        }
        if (system && !Character.isUpperCase(nameCharArray[0]) || !system && !Character.isUpperCase(nameCharArray[2])) {
            throw new ObjectDefinitionNameException.MustBeginWithUpperCaseLetter();
        }
        if (system && nameCharArray.length > 41 || !system && nameCharArray.length > 43) {
            throw new ObjectDefinitionNameException.MustBeLessThan41Characters();
        }
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, name);
        if (objectDefinition != null && objectDefinition.getObjectDefinitionId() != objectDefinitionId) {
            throw new ObjectDefinitionNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateObjectFieldId(ObjectDefinition objectDefinition, long objectFieldId) throws PortalException {
        if (objectFieldId <= 0L) {
            return;
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectFieldId);
        if (objectField == null || objectField.getObjectDefinitionId() != objectDefinition.getObjectDefinitionId()) {
            throw new NoSuchObjectFieldException();
        }
        if (Validator.isNotNull((String)objectField.getRelationshipType())) {
            throw new ObjectFieldRelationshipTypeException("Description and title object fields cannot have a relationship type");
        }
    }

    private void _validatePluralLabel(Map<Locale, String> pluralLabelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (pluralLabelMap == null || Validator.isNull((String)pluralLabelMap.get(locale))) {
            throw new ObjectDefinitionPluralLabelException("Plural label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateScope(String scope) throws PortalException {
        if (Validator.isNull((String)scope)) {
            throw new ObjectDefinitionScopeException("Scope is null");
        }
        try {
            this._objectScopeProviderRegistry.getObjectScopeProvider(scope);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectDefinitionScopeException(illegalArgumentException.getMessage());
        }
    }

    private void _validateVersion(boolean system, int version) throws PortalException {
        if (system) {
            if (version <= 0) {
                throw new ObjectDefinitionVersionException("System object definition versions must greater than 0");
            }
        } else if (version != 0) {
            throw new ObjectDefinitionVersionException("Custom object definition versions must be 0");
        }
    }
}

