/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.exception.ObjectActionConditionExpressionException;
import com.liferay.object.exception.ObjectActionExecutorKeyException;
import com.liferay.object.exception.ObjectActionNameException;
import com.liferay.object.exception.ObjectActionParametersException;
import com.liferay.object.exception.ObjectActionTriggerKeyException;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.scripting.exception.ObjectScriptingException;
import com.liferay.object.scripting.validator.ObjectScriptingValidator;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.base.ObjectActionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectAction"}, service={AopService.class})
public class ObjectActionLocalServiceImpl
extends ObjectActionLocalServiceBaseImpl {
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectScriptingValidator _objectScriptingValidator;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction addObjectAction(long userId, long objectDefinitionId, boolean active, String conditionExpression, String description, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        this._validate(conditionExpression, name, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ObjectAction objectAction = this.objectActionPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectAction.setCompanyId(user.getCompanyId());
        objectAction.setUserId(user.getUserId());
        objectAction.setUserName(user.getFullName());
        objectAction.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectAction.setActive(active);
        objectAction.setConditionExpression(conditionExpression);
        objectAction.setDescription(description);
        objectAction.setName(name);
        objectAction.setObjectActionExecutorKey(objectActionExecutorKey);
        objectAction.setObjectActionTriggerKey(objectActionTriggerKey);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        objectAction.setStatus(0);
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectAction deleteObjectAction(long objectActionId) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        return this.deleteObjectAction(objectAction);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectAction deleteObjectAction(ObjectAction objectAction) {
        return (ObjectAction)this.objectActionPersistence.remove((BaseModel)objectAction);
    }

    public void deleteObjectActions(long objectDefinitionId) throws PortalException {
        for (ObjectAction objectAction : this.objectActionPersistence.findByObjectDefinitionId(objectDefinitionId)) {
            this.objectActionLocalService.deleteObjectAction(objectAction);
        }
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId) {
        return this.objectActionPersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId, String objectActionTriggerKey) {
        return this.objectActionPersistence.findByO_A_OATK(objectDefinitionId, true, objectActionTriggerKey);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateObjectAction(long objectActionId, boolean active, String conditionExpression, String description, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        this._validate(conditionExpression, name, objectActionExecutorKey, objectActionTriggerKey, parametersUnicodeProperties);
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        objectAction.setActive(active);
        objectAction.setConditionExpression(conditionExpression);
        objectAction.setDescription(description);
        objectAction.setName(name);
        objectAction.setObjectActionExecutorKey(objectActionExecutorKey);
        objectAction.setObjectActionTriggerKey(objectActionTriggerKey);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        objectAction.setStatus(0);
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateStatus(long objectActionId, int status) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        objectAction.setStatus(status);
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    private void _validate(String conditionExpression, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new ObjectActionNameException();
        }
        if (!this._objectActionExecutorRegistry.hasObjectActionExecutor(objectActionExecutorKey)) {
            throw new ObjectActionExecutorKeyException(objectActionExecutorKey);
        }
        if (!(Objects.equals(objectActionTriggerKey, "onAfterAdd") || Objects.equals(objectActionTriggerKey, "onAfterDelete") || Objects.equals(objectActionTriggerKey, "onAfterUpdate"))) {
            if (!this._messageBus.hasDestination(objectActionTriggerKey)) {
                throw new ObjectActionTriggerKeyException();
            }
            if (Validator.isNotNull((String)conditionExpression)) {
                throw new ObjectActionConditionExpressionException();
            }
        }
        HashMap<String, Object> errorMessageKeys = new HashMap<String, Object>();
        if (Validator.isNotNull((String)conditionExpression)) {
            try {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)conditionExpression).build());
            }
            catch (Exception exception) {
                errorMessageKeys.put("conditionExpression", "syntax-error");
            }
        }
        if (Objects.equals(objectActionExecutorKey, "add-object-entry")) {
            long objectDefinitionId = GetterUtil.getLong((String)((String)parametersUnicodeProperties.get((Object)"objectDefinitionId")));
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
            if (objectDefinition == null || !objectDefinition.isActive() || !objectDefinition.isApproved() || objectDefinition.isSystem()) {
                errorMessageKeys.put("objectDefinitionId", "invalid");
            } else {
                this._validatePredefinedValues(errorMessageKeys, objectDefinitionId, this._jsonFactory.createJSONArray((String)parametersUnicodeProperties.get((Object)"predefinedValues")));
            }
        } else if (Objects.equals(objectActionExecutorKey, "groovy")) {
            String script = (String)parametersUnicodeProperties.get((Object)"script");
            if (Validator.isNotNull((String)script)) {
                try {
                    this._objectScriptingValidator.validate("groovy", script);
                }
                catch (ObjectScriptingException objectScriptingException) {
                    errorMessageKeys.put("script", objectScriptingException.getMessageKey());
                }
            }
        } else if (Objects.equals(objectActionExecutorKey, "webhook") && Validator.isNull((String)((String)parametersUnicodeProperties.get((Object)"url")))) {
            errorMessageKeys.put("url", "required");
        }
        if (MapUtil.isNotEmpty(errorMessageKeys)) {
            throw new ObjectActionParametersException(errorMessageKeys);
        }
    }

    private void _validatePredefinedValues(Map<String, Object> errorMessageKeys, long objectDefinitionId, JSONArray predefinedValuesJSONArray) {
        HashMap<String, String> predefinedValuesErrorMessageKeys = new HashMap<String, String>();
        HashMap<String, String> predefinedValuesMap = new HashMap<String, String>();
        for (int i = 0; i < predefinedValuesJSONArray.length(); ++i) {
            JSONObject predefinedValueJSONObject = predefinedValuesJSONArray.getJSONObject(i);
            String name = predefinedValueJSONObject.getString("name");
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId, name);
            if (objectField == null) {
                predefinedValuesErrorMessageKeys.put(name, "invalid");
                continue;
            }
            String value = predefinedValueJSONObject.getString("value");
            predefinedValuesMap.put(name, value);
            if (Validator.isNull((String)value) || predefinedValueJSONObject.getBoolean("inputAsValue")) continue;
            try {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)value).build());
                continue;
            }
            catch (Exception exception) {
                predefinedValuesErrorMessageKeys.put(name, "syntax-error");
            }
        }
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinitionId)) {
            if (!objectField.isRequired() || Validator.isNotNull((String)((String)predefinedValuesMap.get(objectField.getName())))) continue;
            predefinedValuesErrorMessageKeys.put(objectField.getName(), "required");
        }
        if (MapUtil.isNotEmpty(predefinedValuesErrorMessageKeys)) {
            errorMessageKeys.put("predefinedValues", predefinedValuesErrorMessageKeys);
        }
    }
}

