/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectState;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.object.service.ObjectStateLocalServiceUtil;
import com.liferay.object.service.persistence.ObjectStatePersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ObjectStateLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ObjectStateLocalService {
    protected ObjectStateLocalService objectStateLocalService;
    @Reference
    protected ObjectStatePersistence objectStatePersistence;
    @Reference
    protected CounterLocalService counterLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectState addObjectState(ObjectState objectState) {
        objectState.setNew(true);
        return (ObjectState)this.objectStatePersistence.update((BaseModel)objectState);
    }

    @Transactional(enabled=false)
    public ObjectState createObjectState(long objectStateId) {
        return this.objectStatePersistence.create(objectStateId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectState deleteObjectState(long objectStateId) throws PortalException {
        return this.objectStatePersistence.remove(objectStateId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectState deleteObjectState(ObjectState objectState) {
        return (ObjectState)this.objectStatePersistence.remove((BaseModel)objectState);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.objectStatePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(ObjectState.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.objectStatePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.objectStatePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.objectStatePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.objectStatePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.objectStatePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public ObjectState fetchObjectState(long objectStateId) {
        return this.objectStatePersistence.fetchByPrimaryKey(objectStateId);
    }

    public ObjectState fetchObjectStateByUuidAndCompanyId(String uuid, long companyId) {
        return this.objectStatePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public ObjectState getObjectState(long objectStateId) throws PortalException {
        return this.objectStatePersistence.findByPrimaryKey(objectStateId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectStateLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectState.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectStateId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectStateLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(ObjectState.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("objectStateId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectStateLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectState.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectStateId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ObjectState>(){

            public void performAction(ObjectState objectState) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)objectState);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)ObjectState.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.objectStatePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.objectStateLocalService.deleteObjectState((ObjectState)persistedModel);
    }

    public BasePersistence<ObjectState> getBasePersistence() {
        return this.objectStatePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.objectStatePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public ObjectState getObjectStateByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.objectStatePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<ObjectState> getObjectStates(int start, int end) {
        return this.objectStatePersistence.findAll(start, end);
    }

    public int getObjectStatesCount() {
        return this.objectStatePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectState updateObjectState(ObjectState objectState) {
        return (ObjectState)this.objectStatePersistence.update((BaseModel)objectState);
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ObjectStateLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.objectStateLocalService = (ObjectStateLocalService)aopProxy;
        this._setLocalServiceUtilService(this.objectStateLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return ObjectStateLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return ObjectState.class;
    }

    protected String getModelClassName() {
        return ObjectState.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.objectStatePersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(ObjectStateLocalService objectStateLocalService) {
        try {
            Field field = ObjectStateLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, objectStateLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

