/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SystemObject1toMObjectRelatedModelsProviderImpl<T extends BaseModel<T>>
implements ObjectRelatedModelsProvider<T> {
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    private final SystemObjectDefinitionMetadata _systemObjectDefinitionMetadata;
    private final Table _table;

    public SystemObject1toMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
        this._objectDefinition = objectDefinition;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._persistedModelLocalServiceRegistry = persistedModelLocalServiceRegistry;
        this._systemObjectDefinitionMetadata = systemObjectDefinitionMetadata;
        this._table = systemObjectDefinitionMetadata.getTable();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        List<T> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, primaryKey, -1, -1);
        if (relatedModels.isEmpty()) {
            return;
        }
        if (Objects.equals(objectRelationship.getDeletionType(), "cascade")) {
            PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionMetadata.getModelClassName());
            for (BaseModel baseModel : relatedModels) {
                persistedModelLocalService.deletePersistedModel((PersistedModel)baseModel);
            }
        } else if (Objects.equals(objectRelationship.getDeletionType(), "disassociate")) {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            for (BaseModel baseModel : relatedModels) {
                this._objectEntryLocalService.insertIntoOrUpdateExtensionTable(objectRelationship.getObjectDefinitionId2(), GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()), (Map)HashMapBuilder.put((Object)objectField.getName(), (Object)0).build());
            }
        } else if (Objects.equals(objectRelationship.getDeletionType(), "prevent")) {
            throw new RequiredObjectRelationshipException(StringBundler.concat((Object[])new Object[]{"Object relationship ", objectRelationship.getObjectRelationshipId(), " does not allow deletes"}));
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        this._objectEntryLocalService.insertIntoOrUpdateExtensionTable(objectRelationship.getObjectDefinitionId2(), GetterUtil.getLong((Object)primaryKey2), (Map)HashMapBuilder.put(() -> {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            return objectField.getName();
        }, (Object)0).build());
    }

    public String getClassName() {
        return this._systemObjectDefinitionMetadata.getModelClassName();
    }

    public String getObjectRelationshipType() {
        return "oneToMany";
    }

    public List<T> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, int start, int end) throws PortalException {
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionMetadata.getModelClassName());
        DSLQuery dslQuery = this._getGroupByStep(this._getDynamicObjectDefinitionTable(), groupId, objectRelationshipId, primaryKey, DSLQueryFactoryUtil.selectDistinct((Table)this._table)).limit(start, end);
        return (List)persistedModelLocalService.dslQuery(dslQuery);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable();
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(this._systemObjectDefinitionMetadata.getModelClassName());
        return persistedModelLocalService.dslQueryCount((DSLQuery)this._getGroupByStep(dynamicObjectDefinitionTable, groupId, objectRelationshipId, primaryKey, DSLQueryFactoryUtil.countDistinct(dynamicObjectDefinitionTable.getPrimaryKeyColumn())));
    }

    public List<T> getUnrelatedModels(long companyId, long groupId, ObjectDefinition objectDefinition, long objectEntryId, long objectRelationshipId) throws PortalException {
        Column companyIdColumn = this._table.getColumn("companyId");
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(objectDefinition.getClassName());
        return (List)persistedModelLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)this._table).from(this._table).where(companyIdColumn.eq((Object)companyId).and(() -> {
            Column groupIdColumn = this._table.getColumn("groupId");
            if (groupIdColumn == null) {
                return null;
            }
            return groupIdColumn.eq((Object)groupId);
        }).and(() -> {
            Column primaryKeyColumn = this._table.getColumn(objectDefinition.getPKObjectFieldDBColumnName());
            DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable();
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            Column foreignKeyColumn = dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
            return primaryKeyColumn.notIn((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{dynamicObjectDefinitionTable.getPrimaryKeyColumn()}).from((Table)dynamicObjectDefinitionTable).where(foreignKeyColumn.neq((Object)0L)));
        })));
    }

    private DynamicObjectDefinitionTable _getDynamicObjectDefinitionTable() {
        return new DynamicObjectDefinitionTable(this._objectDefinition, this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId(), this._objectDefinition.getExtensionDBTableName()), this._objectDefinition.getExtensionDBTableName());
    }

    private GroupByStep _getGroupByStep(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long groupId, long objectRelationshipId, long primaryKey, FromStep fromStep) throws PortalException {
        Column primaryKeyColumn = null;
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        primaryKeyColumn = Objects.equals(objectField.getDBTableName(), this._table) ? this._table.getColumn(objectField.getDBColumnName()) : dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
        return fromStep.from(this._table).innerJoinON((Table)dynamicObjectDefinitionTable, dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Expression)this._systemObjectDefinitionMetadata.getPrimaryKeyColumn())).where(primaryKeyColumn.eq((Object)primaryKey).and(() -> {
            Column groupIdColumn = this._table.getColumn("groupId");
            if (groupIdColumn == null) {
                return null;
            }
            return groupIdColumn.eq((Object)groupId);
        }).and(() -> {
            Column companyIdColumn = this._table.getColumn("companyId");
            if (companyIdColumn == null) {
                return null;
            }
            return companyIdColumn.eq((Object)objectField.getCompanyId());
        }));
    }
}

