/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectView;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectViewModelListener
extends BaseModelListener<ObjectView> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectView objectView) throws ModelListenerException {
        this._route("ADD", objectView);
    }

    public void onBeforeRemove(ObjectView objectView) throws ModelListenerException {
        this._route("DELETE", objectView);
    }

    public void onBeforeUpdate(ObjectView originalObjectView, ObjectView objectView) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectView.class.getName(), (long)objectView.getObjectViewId(), this._getModifiedAttributes(originalObjectView, objectView)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectView originalObjectView, ObjectView objectView) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectView, (Object)originalObjectView);
        attributesBuilder.add("defaultObjectView");
        attributesBuilder.add("nameMap");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectView objectView) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectView.class.getName(), (long)objectView.getObjectViewId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("defaultObjectView", objectView.isDefaultObjectView()).put("nameMap", (Object)objectView.getNameMap());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

