/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectValidationRule;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectValidationRuleModelListener
extends BaseModelListener<ObjectValidationRule> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectValidationRule objectValidationRule) throws ModelListenerException {
        this._route("ADD", objectValidationRule);
    }

    public void onBeforeRemove(ObjectValidationRule objectValidationRule) throws ModelListenerException {
        this._route("DELETE", objectValidationRule);
    }

    public void onBeforeUpdate(ObjectValidationRule originalObjectValidationRule, ObjectValidationRule objectValidationRule) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectValidationRule.class.getName(), (long)objectValidationRule.getObjectValidationRuleId(), this._getModifiedAttributes(originalObjectValidationRule, objectValidationRule)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectValidationRule originalObjectValidationRule, ObjectValidationRule objectValidationRule) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectValidationRule, (Object)originalObjectValidationRule);
        attributesBuilder.add("active");
        attributesBuilder.add("engine");
        attributesBuilder.add("errorLabelMap");
        attributesBuilder.add("nameMap");
        attributesBuilder.add("script");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectValidationRule objectValidationRule) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectValidationRule.class.getName(), (long)objectValidationRule.getObjectValidationRuleId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("active", objectValidationRule.isActive()).put("engine", objectValidationRule.getEngine()).put("errorLabelMap", (Object)objectValidationRule.getErrorLabelMap()).put("nameMap", (Object)objectValidationRule.getNameMap()).put("script", objectValidationRule.getScript());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

