/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectRelationship;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectRelationshipModelListener
extends BaseModelListener<ObjectRelationship> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectRelationship objectRelationship) throws ModelListenerException {
        this._route("ADD", objectRelationship);
    }

    public void onBeforeRemove(ObjectRelationship objectRelationship) throws ModelListenerException {
        this._route("DELETE", objectRelationship);
    }

    public void onBeforeUpdate(ObjectRelationship originalObjectRelationship, ObjectRelationship objectRelationship) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectRelationship.class.getName(), (long)objectRelationship.getObjectRelationshipId(), this._getModifiedAttributes(originalObjectRelationship, objectRelationship)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectRelationship originalObjectRelationship, ObjectRelationship objectRelationship) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectRelationship, (Object)originalObjectRelationship);
        attributesBuilder.add("deletionType");
        attributesBuilder.add("labelMap");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectRelationship objectRelationship) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectRelationship.class.getName(), (long)objectRelationship.getObjectRelationshipId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("deletionType", objectRelationship.getDeletionType()).put("labelMap", (Object)objectRelationship.getLabelMap());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

