/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Collections;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelListener.class);
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectActionEngine _objectActionEngine;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("onAfterAdd", null, objectEntry);
    }

    public void onAfterRemove(ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("onAfterDelete", null, objectEntry);
    }

    public void onAfterUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("onAfterUpdate", originalObjectEntry, objectEntry);
    }

    public void onBeforeCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._validateObjectEntry(objectEntry);
    }

    public void onBeforeUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._validateObjectEntry(objectEntry);
    }

    private void _executeObjectActions(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        try {
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = objectEntry.getUserId();
            }
            this._objectActionEngine.executeObjectActions(objectEntry.getModelClassName(), objectEntry.getCompanyId(), objectActionTriggerKey, this._getPayloadJSONObject(objectActionTriggerKey, originalObjectEntry, objectEntry, userId), userId);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private String _getObjectDefinitionShortName(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        return objectDefinition.getShortName();
    }

    private JSONObject _getPayloadJSONObject(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry, long userId) throws PortalException {
        String objectDefinitionShortName = this._getObjectDefinitionShortName(objectEntry.getObjectDefinitionId());
        User user = this._userLocalService.getUser(userId);
        return JSONUtil.put((String)"classPK", (Object)objectEntry.getObjectEntryId()).put("objectActionTriggerKey", objectActionTriggerKey).put("objectEntry", (Object)HashMapBuilder.putAll((Map)objectEntry.getModelAttributes()).put((Object)"values", (Object)objectEntry.getValues()).build()).put("objectEntryDTO" + objectDefinitionShortName, this._toDTO(objectEntry, user)).put("originalObjectEntry", () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return HashMapBuilder.putAll((Map)originalObjectEntry.getModelAttributes()).put((Object)"values", (Object)originalObjectEntry.getValues()).build();
        }).put("originalObjectEntryDTO" + objectDefinitionShortName, () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return this._toDTO(originalObjectEntry, user);
        });
    }

    private Map<String, Object> _toDTO(ObjectEntry objectEntry, User user) throws PortalException {
        DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(ObjectEntry.class.getName());
        if (dtoConverter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No DTO converter found for " + ObjectEntry.class.getName()));
            }
            return objectEntry.getModelAttributes();
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), this._dtoConverterRegistry, null, user.getLocale(), null, user);
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep(dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, (Object)objectEntry)));
            return jsonObject.toMap();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return objectEntry.getModelAttributes();
        }
    }

    private void _validateObjectEntry(ObjectEntry objectEntry) throws ModelListenerException {
        try {
            this._objectValidationRuleLocalService.validate((BaseModel)objectEntry, objectEntry.getObjectDefinitionId());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

