/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectAction;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectActionModelListener
extends BaseModelListener<ObjectAction> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectAction objectAction) throws ModelListenerException {
        this._route("ADD", objectAction);
    }

    public void onBeforeRemove(ObjectAction objectAction) throws ModelListenerException {
        this._route("DELETE", objectAction);
    }

    public void onBeforeUpdate(ObjectAction originalObjectAction, ObjectAction objectAction) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectAction.class.getName(), (long)objectAction.getObjectActionId(), this._getModifiedAttributes(originalObjectAction, objectAction)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectAction originalObjectAction, ObjectAction objectAction) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectAction, (Object)originalObjectAction);
        attributesBuilder.add("active");
        attributesBuilder.add("name");
        attributesBuilder.add("parameters");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectAction objectAction) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectAction.class.getName(), (long)objectAction.getObjectActionId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("active", objectAction.isActive()).put("conditionExpression", objectAction.getConditionExpression()).put("name", objectAction.getName()).put("parameters", objectAction.getParameters());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

