/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.field.business.type.key=LongText"}, service={LongTextObjectFieldBusinessType.class, ObjectFieldBusinessType.class})
public class LongTextObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"maxLength", "showCounter"});
    }

    public String getDBType() {
        return "Clob";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDescription(Locale locale) {
        return this._language.get(ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), "add-text-that-up-to-65,000-characters");
    }

    public String getLabel(Locale locale) {
        return this._language.get(ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), "long-text");
    }

    public String getName() {
        return "LongText";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        HashMap properties = HashMapBuilder.put((Object)"displayStyle", (Object)"multiline").build();
        ListUtil.isNotEmptyForEach((List)this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()), objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return properties;
    }

    public void validateObjectFieldSettings(long objectDefinitionId, String objectFieldName, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectDefinitionId, objectFieldName, objectFieldSettings);
        HashMap objectFieldSettingsValues = new HashMap();
        objectFieldSettings.forEach(objectFieldSetting -> objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        String showCounter = (String)objectFieldSettingsValues.get("showCounter");
        if (Validator.isNull((String)showCounter) || StringUtil.equalsIgnoreCase((String)showCounter, (String)"false")) {
            if (objectFieldSettingsValues.containsKey("maxLength")) {
                throw new ObjectFieldSettingNameException.NotAllowedNames(objectFieldName, Collections.singleton("maxLength"));
            }
        } else if (StringUtil.equalsIgnoreCase((String)showCounter, (String)"true")) {
            String maxLength = (String)objectFieldSettingsValues.get("maxLength");
            if (Validator.isNull((String)maxLength)) {
                throw new ObjectFieldSettingValueException.MissingRequiredValues(objectFieldName, Collections.singleton("maxLength"));
            }
            int maxLengthInteger = GetterUtil.getInteger((String)maxLength);
            if (maxLengthInteger < 1 || maxLengthInteger > 65000) {
                throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "maxLength", maxLength);
            }
        } else {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "showCounter", showCounter);
        }
    }
}

