/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFieldSettingModel;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.field.business.type.key=Attachment"}, service={ObjectFieldBusinessType.class})
public class AttachmentObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"showFilesInDocumentsAndMedia", "storageDLFolderPath"});
    }

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "attachment";
    }

    public String getDescription(Locale locale) {
        return this._language.get(ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), "upload-files-or-select-from-documents-and-media");
    }

    public String getLabel(Locale locale) {
        return this._language.get(ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), "attachment");
    }

    public String getName() {
        return "Attachment";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        HashMap properties = HashMapBuilder.put((Object)"objectFieldId", (Object)objectField.getObjectFieldId()).put((Object)"portletId", (Object)objectFieldRenderingContext.getPortletId()).build();
        ListUtil.isNotEmptyForEach((List)this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()), objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        properties.remove("showFilesInDocumentsAndMedia");
        properties.remove("storageDLFolderPath");
        return properties;
    }

    public Set<String> getRequiredObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"acceptedFileExtensions", "fileSource", "maximumFileSize"});
    }

    public void validateObjectFieldSettings(long objectDefinitionId, String objectFieldName, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectDefinitionId, objectFieldName, objectFieldSettings);
        Stream stream = objectFieldSettings.stream();
        Map<String, String> objectFieldSettingsValuesMap = stream.collect(Collectors.toMap(ObjectFieldSettingModel::getName, ObjectFieldSettingModel::getValue));
        this._validateObjectFieldSettingFileSource(objectFieldSettingsValuesMap.get("fileSource"), objectFieldName, objectFieldSettingsValuesMap.get("showFilesInDocumentsAndMedia"), objectFieldSettingsValuesMap.get("storageDLFolderPath"));
        this._validateObjectFieldSettingMaximumFileSize(objectFieldName, objectFieldSettingsValuesMap.get("maximumFileSize"));
    }

    private void _validateObjectFieldSettingFileSource(String fileSource, String objectFieldName, String showFilesInDocumentsAndMedia, String storageDLFolderPath) throws PortalException {
        if (Objects.equals(fileSource, "documentsAndMedia")) {
            this._validateObjectFieldSettingFileSourceDocumentsAndMedia(objectFieldName, showFilesInDocumentsAndMedia, storageDLFolderPath);
        } else if (Objects.equals(fileSource, "userComputer")) {
            this._validateObjectFieldSettingFileSourceUserComputer(objectFieldName, showFilesInDocumentsAndMedia, storageDLFolderPath);
        } else {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "fileSource", fileSource);
        }
    }

    private void _validateObjectFieldSettingFileSourceDocumentsAndMedia(String objectFieldName, String showFilesInDocumentsAndMedia, String storageDLFolderPath) throws PortalException {
        HashSet<String> notAllowedObjectFieldSettingsNames = new HashSet<String>();
        if (Validator.isNotNull((String)showFilesInDocumentsAndMedia)) {
            notAllowedObjectFieldSettingsNames.add("showFilesInDocumentsAndMedia");
        }
        if (Validator.isNotNull((String)storageDLFolderPath)) {
            notAllowedObjectFieldSettingsNames.add("storageDLFolderPath");
        }
        if (!notAllowedObjectFieldSettingsNames.isEmpty()) {
            throw new ObjectFieldSettingNameException.NotAllowedNames(objectFieldName, notAllowedObjectFieldSettingsNames);
        }
    }

    private void _validateObjectFieldSettingFileSourceUserComputer(String objectFieldName, String showFilesInDocumentsAndMedia, String storageDLFolderPath) throws PortalException {
        if (Validator.isNull((String)showFilesInDocumentsAndMedia) || StringUtil.equalsIgnoreCase((String)showFilesInDocumentsAndMedia, (String)"false")) {
            if (Validator.isNotNull((String)storageDLFolderPath)) {
                throw new ObjectFieldSettingNameException.NotAllowedNames(objectFieldName, Collections.singleton("storageDLFolderPath"));
            }
        } else if (StringUtil.equalsIgnoreCase((String)showFilesInDocumentsAndMedia, (String)"true")) {
            if (Validator.isNull((String)storageDLFolderPath)) {
                throw new ObjectFieldSettingValueException.MissingRequiredValues(objectFieldName, Collections.singleton("storageDLFolderPath"));
            }
            if (Validator.isNotNull((String)storageDLFolderPath) && storageDLFolderPath.length() > 255) {
                throw new ObjectFieldSettingValueException.MustBeLessThan256Characters();
            }
            for (String directoryName : StringUtil.split((String)storageDLFolderPath, (char)'/')) {
                DLValidatorUtil.validateDirectoryName((String)directoryName);
            }
        } else {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "showFilesInDocumentsAndMedia", showFilesInDocumentsAndMedia);
        }
    }

    private void _validateObjectFieldSettingMaximumFileSize(String objectFieldName, String objectFieldSettingValue) throws PortalException {
        try {
            BigDecimal maximumFileSize = new BigDecimal(objectFieldSettingValue);
            if (maximumFileSize.signum() == -1) {
                throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "maximumFileSize", objectFieldSettingValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "maximumFileSize", objectFieldSettingValue, (Throwable)numberFormatException);
        }
    }
}

