/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.engine;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.internal.action.util.ObjectActionVariablesUtil;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadataTracker;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionEngine.class})
public class ObjectActionEngineImpl
implements ObjectActionEngine {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionEngineImpl.class);
    private static final ThreadLocal<Set<Long>> _objectActionIdsThreadLocal = new CentralizedThreadLocal(ObjectActionEngineImpl.class.getName() + "._objectActionIdsThreadLocal", HashSet::new);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private SystemObjectDefinitionMetadataTracker _systemObjectDefinitionMetadataTracker;
    @Reference
    private UserLocalService _userLocalService;

    public void executeObjectActions(String className, long companyId, String objectActionTriggerKey, JSONObject payloadJSONObject, long userId) {
        try {
            this._executeObjectActions(className, companyId, objectActionTriggerKey, payloadJSONObject, userId);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private boolean _evaluateConditionExpression(String conditionExpression, Map<String, Object> variables) throws Exception {
        if (Validator.isNull((String)conditionExpression)) {
            return true;
        }
        DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)conditionExpression).build());
        ddmExpression.setVariables(variables);
        return (Boolean)ddmExpression.evaluate();
    }

    private void _executeObjectActions(String className, long companyId, String objectActionTriggerKey, JSONObject payloadJSONObject, long userId) throws Exception {
        if (companyId == 0L || userId == 0L) {
            return;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null || companyId != user.getCompanyId()) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(user.getCompanyId(), className);
        if (objectDefinition == null) {
            return;
        }
        payloadJSONObject.put("companyId", companyId).put("objectDefinitionId", objectDefinition.getObjectDefinitionId()).put("userId", userId);
        Set<Long> objectActionIds = _objectActionIdsThreadLocal.get();
        Map<String, Object> variables = ObjectActionVariablesUtil.toVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionMetadataTracker);
        for (ObjectAction objectAction : this._objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), objectActionTriggerKey)) {
            try {
                if (objectActionIds.contains(objectAction.getObjectActionId()) || !this._evaluateConditionExpression(objectAction.getConditionExpression(), variables)) continue;
                objectActionIds.add(objectAction.getObjectActionId());
                ObjectActionExecutor objectActionExecutor = this._objectActionExecutorRegistry.getObjectActionExecutor(objectAction.getObjectActionExecutorKey());
                objectActionExecutor.execute(companyId, objectAction.getParametersUnicodeProperties(), payloadJSONObject, userId);
                this._objectActionLocalService.updateStatus(objectAction.getObjectActionId(), 1);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                this._objectActionLocalService.updateStatus(objectAction.getObjectActionId(), 2);
            }
        }
    }
}

