/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectRelationshipModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectRelationship service. Represents a row in the &quot;ObjectRelationship&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectRelationshipModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectRelationshipImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectRelationshipImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectRelationshipModelImpl
	extends BaseModelImpl<ObjectRelationship>
	implements ObjectRelationshipModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object relationship model instance should use the <code>ObjectRelationship</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectRelationship";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectRelationshipId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectDefinitionId1", Types.BIGINT},
		{"objectDefinitionId2", Types.BIGINT}, {"objectFieldId2", Types.BIGINT},
		{"parameterObjectFieldId", Types.BIGINT},
		{"deletionType", Types.VARCHAR}, {"dbTableName", Types.VARCHAR},
		{"label", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"reverse", Types.BOOLEAN}, {"type_", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectRelationshipId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectDefinitionId1", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectDefinitionId2", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectFieldId2", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parameterObjectFieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("deletionType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("dbTableName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("label", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("reverse", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectRelationship (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectRelationshipId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectDefinitionId1 LONG,objectDefinitionId2 LONG,objectFieldId2 LONG,parameterObjectFieldId LONG,deletionType VARCHAR(75) null,dbTableName VARCHAR(75) null,label STRING null,name VARCHAR(75) null,reverse BOOLEAN,type_ VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table ObjectRelationship";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectRelationship.objectRelationshipId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectRelationship.objectRelationshipId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONID1_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONID2_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDID2_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REVERSE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTRELATIONSHIPID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectRelationshipModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectRelationshipId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectRelationshipId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectRelationshipId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectRelationship.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectRelationship.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectRelationship, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectRelationship, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectRelationship, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectRelationship)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectRelationship, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectRelationship, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectRelationship)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectRelationship, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectRelationship, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<ObjectRelationship, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<ObjectRelationship, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<ObjectRelationship, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<ObjectRelationship, Object>>();
		Map<String, BiConsumer<ObjectRelationship, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<ObjectRelationship, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ObjectRelationship::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setMvccVersion);
		attributeGetterFunctions.put("uuid", ObjectRelationship::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ObjectRelationship, String>)
				ObjectRelationship::setUuid);
		attributeGetterFunctions.put(
			"objectRelationshipId",
			ObjectRelationship::getObjectRelationshipId);
		attributeSetterBiConsumers.put(
			"objectRelationshipId",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setObjectRelationshipId);
		attributeGetterFunctions.put(
			"companyId", ObjectRelationship::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setCompanyId);
		attributeGetterFunctions.put("userId", ObjectRelationship::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setUserId);
		attributeGetterFunctions.put(
			"userName", ObjectRelationship::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ObjectRelationship, String>)
				ObjectRelationship::setUserName);
		attributeGetterFunctions.put(
			"createDate", ObjectRelationship::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ObjectRelationship, Date>)
				ObjectRelationship::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ObjectRelationship::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ObjectRelationship, Date>)
				ObjectRelationship::setModifiedDate);
		attributeGetterFunctions.put(
			"objectDefinitionId1", ObjectRelationship::getObjectDefinitionId1);
		attributeSetterBiConsumers.put(
			"objectDefinitionId1",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setObjectDefinitionId1);
		attributeGetterFunctions.put(
			"objectDefinitionId2", ObjectRelationship::getObjectDefinitionId2);
		attributeSetterBiConsumers.put(
			"objectDefinitionId2",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setObjectDefinitionId2);
		attributeGetterFunctions.put(
			"objectFieldId2", ObjectRelationship::getObjectFieldId2);
		attributeSetterBiConsumers.put(
			"objectFieldId2",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setObjectFieldId2);
		attributeGetterFunctions.put(
			"parameterObjectFieldId",
			ObjectRelationship::getParameterObjectFieldId);
		attributeSetterBiConsumers.put(
			"parameterObjectFieldId",
			(BiConsumer<ObjectRelationship, Long>)
				ObjectRelationship::setParameterObjectFieldId);
		attributeGetterFunctions.put(
			"deletionType", ObjectRelationship::getDeletionType);
		attributeSetterBiConsumers.put(
			"deletionType",
			(BiConsumer<ObjectRelationship, String>)
				ObjectRelationship::setDeletionType);
		attributeGetterFunctions.put(
			"dbTableName", ObjectRelationship::getDBTableName);
		attributeSetterBiConsumers.put(
			"dbTableName",
			(BiConsumer<ObjectRelationship, String>)
				ObjectRelationship::setDBTableName);
		attributeGetterFunctions.put("label", ObjectRelationship::getLabel);
		attributeSetterBiConsumers.put(
			"label",
			(BiConsumer<ObjectRelationship, String>)
				ObjectRelationship::setLabel);
		attributeGetterFunctions.put("name", ObjectRelationship::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<ObjectRelationship, String>)
				ObjectRelationship::setName);
		attributeGetterFunctions.put("reverse", ObjectRelationship::getReverse);
		attributeSetterBiConsumers.put(
			"reverse",
			(BiConsumer<ObjectRelationship, Boolean>)
				ObjectRelationship::setReverse);
		attributeGetterFunctions.put("type", ObjectRelationship::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<ObjectRelationship, String>)
				ObjectRelationship::setType);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getObjectRelationshipId() {
		return _objectRelationshipId;
	}

	@Override
	public void setObjectRelationshipId(long objectRelationshipId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectRelationshipId = objectRelationshipId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getObjectDefinitionId1() {
		return _objectDefinitionId1;
	}

	@Override
	public void setObjectDefinitionId1(long objectDefinitionId1) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId1 = objectDefinitionId1;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectDefinitionId1() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectDefinitionId1"));
	}

	@JSON
	@Override
	public long getObjectDefinitionId2() {
		return _objectDefinitionId2;
	}

	@Override
	public void setObjectDefinitionId2(long objectDefinitionId2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId2 = objectDefinitionId2;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectDefinitionId2() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectDefinitionId2"));
	}

	@JSON
	@Override
	public long getObjectFieldId2() {
		return _objectFieldId2;
	}

	@Override
	public void setObjectFieldId2(long objectFieldId2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldId2 = objectFieldId2;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectFieldId2() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectFieldId2"));
	}

	@JSON
	@Override
	public long getParameterObjectFieldId() {
		return _parameterObjectFieldId;
	}

	@Override
	public void setParameterObjectFieldId(long parameterObjectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parameterObjectFieldId = parameterObjectFieldId;
	}

	@JSON
	@Override
	public String getDeletionType() {
		if (_deletionType == null) {
			return "";
		}
		else {
			return _deletionType;
		}
	}

	@Override
	public void setDeletionType(String deletionType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deletionType = deletionType;
	}

	@JSON
	@Override
	public String getDBTableName() {
		if (_dbTableName == null) {
			return "";
		}
		else {
			return _dbTableName;
		}
	}

	@Override
	public void setDBTableName(String dbTableName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_dbTableName = dbTableName;
	}

	@JSON
	@Override
	public String getLabel() {
		if (_label == null) {
			return "";
		}
		else {
			return _label;
		}
	}

	@Override
	public String getLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId);
	}

	@Override
	public String getLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId, useDefault);
	}

	@Override
	public String getLabel(String languageId) {
		return LocalizationUtil.getLocalization(getLabel(), languageId);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getLabel(), languageId, useDefault);
	}

	@Override
	public String getLabelCurrentLanguageId() {
		return _labelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getLabelCurrentValue() {
		Locale locale = getLocale(_labelCurrentLanguageId);

		return getLabel(locale);
	}

	@Override
	public Map<Locale, String> getLabelMap() {
		return LocalizationUtil.getLocalizationMap(getLabel());
	}

	@Override
	public void setLabel(String label) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_label = label;
	}

	@Override
	public void setLabel(String label, Locale locale) {
		setLabel(label, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setLabel(String label, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(label)) {
			setLabel(
				LocalizationUtil.updateLocalization(
					getLabel(), "Label", label, languageId, defaultLanguageId));
		}
		else {
			setLabel(
				LocalizationUtil.removeLocalization(
					getLabel(), "Label", languageId));
		}
	}

	@Override
	public void setLabelCurrentLanguageId(String languageId) {
		_labelCurrentLanguageId = languageId;
	}

	@Override
	public void setLabelMap(Map<Locale, String> labelMap) {
		setLabelMap(labelMap, LocaleUtil.getDefault());
	}

	@Override
	public void setLabelMap(
		Map<Locale, String> labelMap, Locale defaultLocale) {

		if (labelMap == null) {
			return;
		}

		setLabel(
			LocalizationUtil.updateLocalization(
				labelMap, getLabel(), "Label",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public boolean getReverse() {
		return _reverse;
	}

	@JSON
	@Override
	public boolean isReverse() {
		return _reverse;
	}

	@Override
	public void setReverse(boolean reverse) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reverse = reverse;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalReverse() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("reverse"));
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalType() {
		return getColumnOriginalValue("type_");
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectRelationship.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectRelationship.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> labelMap = getLabelMap();

		for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getLabel();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectRelationship.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String label = getLabel(defaultLocale);

		if (Validator.isNull(label)) {
			setLabel(getLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setLabel(getLabel(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectRelationship toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectRelationship>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectRelationshipImpl objectRelationshipImpl =
			new ObjectRelationshipImpl();

		objectRelationshipImpl.setMvccVersion(getMvccVersion());
		objectRelationshipImpl.setUuid(getUuid());
		objectRelationshipImpl.setObjectRelationshipId(
			getObjectRelationshipId());
		objectRelationshipImpl.setCompanyId(getCompanyId());
		objectRelationshipImpl.setUserId(getUserId());
		objectRelationshipImpl.setUserName(getUserName());
		objectRelationshipImpl.setCreateDate(getCreateDate());
		objectRelationshipImpl.setModifiedDate(getModifiedDate());
		objectRelationshipImpl.setObjectDefinitionId1(getObjectDefinitionId1());
		objectRelationshipImpl.setObjectDefinitionId2(getObjectDefinitionId2());
		objectRelationshipImpl.setObjectFieldId2(getObjectFieldId2());
		objectRelationshipImpl.setParameterObjectFieldId(
			getParameterObjectFieldId());
		objectRelationshipImpl.setDeletionType(getDeletionType());
		objectRelationshipImpl.setDBTableName(getDBTableName());
		objectRelationshipImpl.setLabel(getLabel());
		objectRelationshipImpl.setName(getName());
		objectRelationshipImpl.setReverse(isReverse());
		objectRelationshipImpl.setType(getType());

		objectRelationshipImpl.resetOriginalValues();

		return objectRelationshipImpl;
	}

	@Override
	public ObjectRelationship cloneWithOriginalValues() {
		ObjectRelationshipImpl objectRelationshipImpl =
			new ObjectRelationshipImpl();

		objectRelationshipImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectRelationshipImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectRelationshipImpl.setObjectRelationshipId(
			this.<Long>getColumnOriginalValue("objectRelationshipId"));
		objectRelationshipImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectRelationshipImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectRelationshipImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectRelationshipImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectRelationshipImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectRelationshipImpl.setObjectDefinitionId1(
			this.<Long>getColumnOriginalValue("objectDefinitionId1"));
		objectRelationshipImpl.setObjectDefinitionId2(
			this.<Long>getColumnOriginalValue("objectDefinitionId2"));
		objectRelationshipImpl.setObjectFieldId2(
			this.<Long>getColumnOriginalValue("objectFieldId2"));
		objectRelationshipImpl.setParameterObjectFieldId(
			this.<Long>getColumnOriginalValue("parameterObjectFieldId"));
		objectRelationshipImpl.setDeletionType(
			this.<String>getColumnOriginalValue("deletionType"));
		objectRelationshipImpl.setDBTableName(
			this.<String>getColumnOriginalValue("dbTableName"));
		objectRelationshipImpl.setLabel(
			this.<String>getColumnOriginalValue("label"));
		objectRelationshipImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		objectRelationshipImpl.setReverse(
			this.<Boolean>getColumnOriginalValue("reverse"));
		objectRelationshipImpl.setType(
			this.<String>getColumnOriginalValue("type_"));

		return objectRelationshipImpl;
	}

	@Override
	public int compareTo(ObjectRelationship objectRelationship) {
		long primaryKey = objectRelationship.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectRelationship)) {
			return false;
		}

		ObjectRelationship objectRelationship = (ObjectRelationship)object;

		long primaryKey = objectRelationship.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectRelationship> toCacheModel() {
		ObjectRelationshipCacheModel objectRelationshipCacheModel =
			new ObjectRelationshipCacheModel();

		objectRelationshipCacheModel.mvccVersion = getMvccVersion();

		objectRelationshipCacheModel.uuid = getUuid();

		String uuid = objectRelationshipCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectRelationshipCacheModel.uuid = null;
		}

		objectRelationshipCacheModel.objectRelationshipId =
			getObjectRelationshipId();

		objectRelationshipCacheModel.companyId = getCompanyId();

		objectRelationshipCacheModel.userId = getUserId();

		objectRelationshipCacheModel.userName = getUserName();

		String userName = objectRelationshipCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectRelationshipCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectRelationshipCacheModel.createDate = createDate.getTime();
		}
		else {
			objectRelationshipCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectRelationshipCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectRelationshipCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectRelationshipCacheModel.objectDefinitionId1 =
			getObjectDefinitionId1();

		objectRelationshipCacheModel.objectDefinitionId2 =
			getObjectDefinitionId2();

		objectRelationshipCacheModel.objectFieldId2 = getObjectFieldId2();

		objectRelationshipCacheModel.parameterObjectFieldId =
			getParameterObjectFieldId();

		objectRelationshipCacheModel.deletionType = getDeletionType();

		String deletionType = objectRelationshipCacheModel.deletionType;

		if ((deletionType != null) && (deletionType.length() == 0)) {
			objectRelationshipCacheModel.deletionType = null;
		}

		objectRelationshipCacheModel.dbTableName = getDBTableName();

		String dbTableName = objectRelationshipCacheModel.dbTableName;

		if ((dbTableName != null) && (dbTableName.length() == 0)) {
			objectRelationshipCacheModel.dbTableName = null;
		}

		objectRelationshipCacheModel.label = getLabel();

		String label = objectRelationshipCacheModel.label;

		if ((label != null) && (label.length() == 0)) {
			objectRelationshipCacheModel.label = null;
		}

		objectRelationshipCacheModel.name = getName();

		String name = objectRelationshipCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectRelationshipCacheModel.name = null;
		}

		objectRelationshipCacheModel.reverse = isReverse();

		objectRelationshipCacheModel.type = getType();

		String type = objectRelationshipCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			objectRelationshipCacheModel.type = null;
		}

		return objectRelationshipCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectRelationship, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectRelationship, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectRelationship, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectRelationship)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<ObjectRelationship, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<ObjectRelationship, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectRelationship, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((ObjectRelationship)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectRelationship>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectRelationship.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectRelationshipId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectDefinitionId1;
	private long _objectDefinitionId2;
	private long _objectFieldId2;
	private long _parameterObjectFieldId;
	private String _deletionType;
	private String _dbTableName;
	private String _label;
	private String _labelCurrentLanguageId;
	private String _name;
	private boolean _reverse;
	private String _type;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectRelationship, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectRelationship)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectRelationshipId", _objectRelationshipId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectDefinitionId1", _objectDefinitionId1);
		_columnOriginalValues.put("objectDefinitionId2", _objectDefinitionId2);
		_columnOriginalValues.put("objectFieldId2", _objectFieldId2);
		_columnOriginalValues.put(
			"parameterObjectFieldId", _parameterObjectFieldId);
		_columnOriginalValues.put("deletionType", _deletionType);
		_columnOriginalValues.put("dbTableName", _dbTableName);
		_columnOriginalValues.put("label", _label);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("reverse", _reverse);
		_columnOriginalValues.put("type_", _type);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectRelationshipId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectDefinitionId1", 256L);

		columnBitmasks.put("objectDefinitionId2", 512L);

		columnBitmasks.put("objectFieldId2", 1024L);

		columnBitmasks.put("parameterObjectFieldId", 2048L);

		columnBitmasks.put("deletionType", 4096L);

		columnBitmasks.put("dbTableName", 8192L);

		columnBitmasks.put("label", 16384L);

		columnBitmasks.put("name", 32768L);

		columnBitmasks.put("reverse", 65536L);

		columnBitmasks.put("type_", 131072L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectRelationship _escapedModel;

}