/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.DefaultObjectViewException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectView;
import com.liferay.object.model.ObjectViewColumn;
import com.liferay.object.service.base.ObjectViewLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectViewColumnPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectView"}, service={AopService.class})
public class ObjectViewLocalServiceImpl
extends ObjectViewLocalServiceBaseImpl {
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectViewColumnPersistence _objectViewColumnPersistence;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectView addObjectView(long userId, long objectDefinitionId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (defaultObjectView) {
            this._validate(0L, objectDefinitionId);
        }
        ObjectView objectView = this.objectViewPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectView.setCompanyId(user.getCompanyId());
        objectView.setUserId(user.getUserId());
        objectView.setUserName(user.getFullName());
        objectView.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectView.setDefaultObjectView(defaultObjectView);
        objectView.setNameMap(nameMap);
        objectView = (ObjectView)this.objectViewPersistence.update((BaseModel)objectView);
        objectView.setObjectViewColumns(this._addObjectViewColumns(user, objectView.getObjectViewId(), objectViewColumns));
        return objectView;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectView deleteObjectView(long objectViewId) throws PortalException {
        return this.deleteObjectView(this.objectViewPersistence.findByPrimaryKey(objectViewId));
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectView deleteObjectView(ObjectView objectView) {
        this._objectViewColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        return (ObjectView)this.objectViewPersistence.remove((BaseModel)objectView);
    }

    @Override
    public ObjectView getObjectView(long objectViewId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        return objectView;
    }

    public List<ObjectView> getObjectViews(long objectDefinitionId) {
        List objectViews = this.objectViewPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectView objectView : objectViews) {
            objectView.setObjectViewColumns(this._objectViewColumnPersistence.findByObjectViewId(objectView.getObjectViewId()));
        }
        return objectViews;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectView updateObjectView(long objectViewId, boolean defaultObjectView, Map<Locale, String> nameMap, List<ObjectViewColumn> objectViewColumns) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.findByPrimaryKey(objectViewId);
        if (defaultObjectView) {
            this._validate(objectViewId, objectView.getObjectDefinitionId());
        }
        this._objectViewColumnPersistence.removeByObjectViewId(objectView.getObjectViewId());
        objectView.setDefaultObjectView(defaultObjectView);
        objectView.setNameMap(nameMap);
        objectView = (ObjectView)this.objectViewPersistence.update((BaseModel)objectView);
        objectView.setObjectViewColumns(this._addObjectViewColumns(this._userLocalService.getUser(objectView.getUserId()), objectView.getObjectViewId(), objectViewColumns));
        return objectView;
    }

    private List<ObjectViewColumn> _addObjectViewColumns(User user, long objectViewId, List<ObjectViewColumn> objectViewColumns) {
        return TransformUtil.transform(objectViewColumns, objectViewColumn -> {
            ObjectViewColumn newObjectViewColumn = this._objectViewColumnPersistence.create(this.counterLocalService.increment());
            newObjectViewColumn.setCompanyId(user.getCompanyId());
            newObjectViewColumn.setUserId(user.getUserId());
            newObjectViewColumn.setUserName(user.getFullName());
            newObjectViewColumn.setObjectViewId(objectViewId);
            newObjectViewColumn.setObjectFieldName(objectViewColumn.getObjectFieldName());
            newObjectViewColumn.setPriority(objectViewColumn.getPriority());
            return (ObjectViewColumn)this._objectViewColumnPersistence.update((BaseModel)newObjectViewColumn);
        });
    }

    private void _validate(long objectViewId, long objectDefinitionId) throws PortalException {
        ObjectView objectView = this.objectViewPersistence.fetchByODI_DOV_First(objectDefinitionId, true, null);
        if (objectView != null && objectView.getObjectViewId() != objectViewId) {
            throw new DefaultObjectViewException("There can only be one default object view");
        }
    }
}

