/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.action.executor.ObjectActionExecutorRegistry;
import com.liferay.object.exception.ObjectActionNameException;
import com.liferay.object.exception.ObjectActionTriggerKeyException;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.base.ObjectActionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectAction"}, service={AopService.class})
public class ObjectActionLocalServiceImpl
extends ObjectActionLocalServiceBaseImpl {
    @Reference
    private MessageBus _messageBus;
    @Reference
    private ObjectActionExecutorRegistry _objectActionExecutorRegistry;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction addObjectAction(long userId, long objectDefinitionId, boolean active, String name, String objectActionExecutorKey, String objectActionTriggerKey, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        this._validate(name);
        if (!this._objectActionExecutorRegistry.hasObjectActionExecutor(objectActionExecutorKey)) {
            throw new ObjectActionTriggerKeyException(objectActionExecutorKey);
        }
        if (!(Objects.equals(objectActionTriggerKey, "onAfterAdd") || Objects.equals(objectActionTriggerKey, "onAfterDelete") || Objects.equals(objectActionTriggerKey, "onAfterUpdate") || this._messageBus.hasDestination(objectActionTriggerKey))) {
            throw new ObjectActionTriggerKeyException();
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ObjectAction objectAction = this.objectActionPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectAction.setCompanyId(user.getCompanyId());
        objectAction.setUserId(user.getUserId());
        objectAction.setUserName(user.getFullName());
        objectAction.setObjectDefinitionId(objectDefinition.getObjectDefinitionId());
        objectAction.setActive(active);
        objectAction.setName(name);
        objectAction.setObjectActionExecutorKey(objectActionExecutorKey);
        objectAction.setObjectActionTriggerKey(objectActionTriggerKey);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectAction deleteObjectAction(long objectActionId) throws PortalException {
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        return this.deleteObjectAction(objectAction);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectAction deleteObjectAction(ObjectAction objectAction) {
        return (ObjectAction)this.objectActionPersistence.remove((BaseModel)objectAction);
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId) {
        return this.objectActionPersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectAction> getObjectActions(long objectDefinitionId, String objectActionTriggerKey) {
        return this.objectActionPersistence.findByO_A_OATK(objectDefinitionId, true, objectActionTriggerKey);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateObjectAction(long objectActionId, boolean active, String name, UnicodeProperties parametersUnicodeProperties) throws PortalException {
        this._validate(name);
        ObjectAction objectAction = this.objectActionPersistence.findByPrimaryKey(objectActionId);
        objectAction.setActive(active);
        objectAction.setName(name);
        objectAction.setParameters(parametersUnicodeProperties.toString());
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    private void _validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new ObjectActionNameException();
        }
    }
}

