/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import java.util.Objects;

public class ObjectEntryMtoMObjectRelatedModelsProviderImpl
implements ObjectRelatedModelsProvider<ObjectEntry> {
    private final String _className;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;

    public ObjectEntryMtoMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._className = objectDefinition.getClassName();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        int count = this.getRelatedModelsCount(groupId, objectRelationshipId, primaryKey);
        if (count == 0) {
            return;
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (objectRelationship.isReverse()) {
            objectRelationship = this._objectRelationshipLocalService.fetchReverseObjectRelationship(objectRelationship, false);
        }
        if (Objects.equals(objectRelationship.getDeletionType(), "cascade") || Objects.equals(objectRelationship.getDeletionType(), "disassociate")) {
            this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey);
        } else if (Objects.equals(objectRelationship.getDeletionType(), "prevent")) {
            throw new RequiredObjectRelationshipException(StringBundler.concat((Object[])new Object[]{"Object relationship ", objectRelationship.getObjectRelationshipId(), " does not allow deletes"}));
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey1, primaryKey2);
    }

    public String getClassName() {
        return this._className;
    }

    public String getObjectRelationshipType() {
        return "manyToMany";
    }

    public List<ObjectEntry> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, int start, int end) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        boolean reverse = objectRelationship.isReverse();
        if (objectRelationship.isReverse()) {
            objectRelationship = this._objectRelationshipLocalService.fetchReverseObjectRelationship(objectRelationship, false);
        }
        return this._objectEntryLocalService.getManyToManyRelatedObjectEntries(groupId, objectRelationship.getObjectRelationshipId(), primaryKey, reverse, start, end);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        boolean reverse = objectRelationship.isReverse();
        if (objectRelationship.isReverse()) {
            objectRelationship = this._objectRelationshipLocalService.fetchReverseObjectRelationship(objectRelationship, false);
        }
        return this._objectEntryLocalService.getManyToManyRelatedObjectEntriesCount(groupId, objectRelationship.getObjectRelationshipId(), primaryKey, reverse);
    }
}

