/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.instance.lifecycle;

import com.liferay.object.internal.related.models.ObjectEntry1toMObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.rest.context.path.RESTContextPathResolverImpl;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class SystemObjectDefinitionMetadataPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(SystemObjectDefinitionMetadataPortalInstanceLifecycleListener.class);
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    private ServiceTrackerList<SystemObjectDefinitionMetadata> _serviceTrackerList;

    public void portalInstanceRegistered(Company company) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered portal instance " + company));
        }
        for (SystemObjectDefinitionMetadata systemObjectDefinitionMetadata : this._serviceTrackerList) {
            this._apply(company.getCompanyId(), systemObjectDefinitionMetadata);
        }
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Activate " + bundleContext));
        }
        this._bundleContext = bundleContext;
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, SystemObjectDefinitionMetadata.class, null, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SystemObjectDefinitionMetadata, SystemObjectDefinitionMetadata>(){

            public SystemObjectDefinitionMetadata addingService(ServiceReference<SystemObjectDefinitionMetadata> serviceReference) {
                SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = (SystemObjectDefinitionMetadata)bundleContext.getService(serviceReference);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding service " + systemObjectDefinitionMetadata));
                }
                SystemObjectDefinitionMetadataPortalInstanceLifecycleListener.this._companyLocalService.forEachCompanyId(companyId -> SystemObjectDefinitionMetadataPortalInstanceLifecycleListener.this._apply(companyId, systemObjectDefinitionMetadata));
                return systemObjectDefinitionMetadata;
            }

            public void modifiedService(ServiceReference<SystemObjectDefinitionMetadata> serviceReference, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
            }

            public void removedService(ServiceReference<SystemObjectDefinitionMetadata> serviceReference, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.object.service)(release.schema.version>=1.0.0))", unbind="-")
    protected void setRelease(Release release) {
    }

    private void _apply(long companyId, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Applying ", systemObjectDefinitionMetadata, " to company ", companyId}));
        }
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.addOrUpdateSystemObjectDefinition(companyId, systemObjectDefinitionMetadata);
            this._bundleContext.registerService(ObjectRelatedModelsProvider.class, (Object)new ObjectEntry1toMObjectRelatedModelsProviderImpl(objectDefinition, this._objectEntryLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService), null);
            this._bundleContext.registerService(RESTContextPathResolver.class, (Object)new RESTContextPathResolverImpl("/o/" + systemObjectDefinitionMetadata.getRESTContextPath(), this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope()), true), (Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build());
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }
}

