/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.base.ObjectFieldServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectField"}, service={AopService.class})
public class ObjectFieldServiceImpl
extends ObjectFieldServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference(target="(resource.name=com.liferay.object)")
    private PortletResourcePermission _portletResourcePermission;

    public ObjectField addCustomObjectField(long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isSystem()) {
            this._portletResourcePermission.check(this.getPermissionChecker(), null, "EXTEND_SYSTEM_OBJECT_DEFINITION");
        } else {
            this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinition.getObjectDefinitionId(), "UPDATE");
        }
        return this.objectFieldLocalService.addCustomObjectField(this.getUserId(), listTypeDefinitionId, objectDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required);
    }

    public ObjectField deleteObjectField(long objectFieldId) throws Exception {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectField.getObjectDefinitionId(), "UPDATE");
        return this.objectFieldLocalService.deleteObjectField(objectFieldId);
    }

    public ObjectField getObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectField.getObjectDefinitionId(), "VIEW");
        return this.objectFieldLocalService.getObjectField(objectFieldId);
    }

    public ObjectField updateCustomObjectField(long objectFieldId, long listTypeDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectField.getObjectDefinitionId(), "UPDATE");
        return this.objectFieldLocalService.updateCustomObjectField(objectFieldId, listTypeDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required);
    }
}

