/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.ObjectDefinitionStatusException;
import com.liferay.object.exception.ObjectFieldBusinessTypeException;
import com.liferay.object.exception.ObjectFieldDBTypeException;
import com.liferay.object.exception.ObjectFieldLabelException;
import com.liferay.object.exception.ObjectFieldNameException;
import com.liferay.object.exception.ObjectFieldRelationshipTypeException;
import com.liferay.object.exception.RequiredObjectFieldException;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.base.ObjectFieldLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectLayoutColumnPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectField"}, service={AopService.class})
public class ObjectFieldLocalServiceImpl
extends ObjectFieldLocalServiceBaseImpl {
    private final Set<String> _businessTypes = SetUtil.fromArray((Object[])new String[]{"Boolean", "Date", "Decimal", "Integer", "LongInteger", "LongText", "Picklist", "PrecisionDecimal", "Relationship", "Text"});
    private final Set<String> _dbTypes = SetUtil.fromArray((Object[])new String[]{"BigDecimal", "Blob", "Boolean", "Clob", "Date", "Double", "Integer", "Long", "String"});
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectLayoutColumnPersistence _objectLayoutColumnPersistence;
    private final Set<String> _reservedNames = SetUtil.fromArray((Object[])new String[]{"companyid", "createdate", "groupid", "id", "lastpublishdate", "modifieddate", "status", "statusbyuserid", "statusbyusername", "statusdate", "userid", "username"});
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addCustomObjectField(long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        name = StringUtil.trim((String)name);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        String dbTableName = objectDefinition.getDBTableName();
        if (objectDefinition.isApproved()) {
            dbTableName = objectDefinition.getExtensionDBTableName();
        }
        ObjectField objectField = this._addObjectField(userId, listTypeDefinitionId, objectDefinitionId, businessType, name + "_", dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required);
        if (objectDefinition.isApproved()) {
            this.runSQL(DynamicObjectDefinitionTable.getAlterTableAddColumnSQL(dbTableName, objectField.getDBColumnName(), dbType));
        }
        return objectField;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addSystemObjectField(long userId, long objectDefinitionId, String businessType, String dbColumnName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        name = StringUtil.trim((String)name);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (Validator.isNull((String)dbColumnName)) {
            dbColumnName = name;
        }
        return this._addObjectField(userId, 0L, objectDefinitionId, businessType, dbColumnName, objectDefinition.getDBTableName(), dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectField deleteObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        return this.deleteObjectField(objectField);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectField deleteObjectField(ObjectField objectField) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectField.getObjectDefinitionId());
        if ((objectDefinition.isApproved() || objectDefinition.isSystem()) && !Objects.equals(objectDefinition.getExtensionDBTableName(), objectField.getDBTableName())) {
            throw new RequiredObjectFieldException();
        }
        objectField = (ObjectField)this.objectFieldPersistence.remove((BaseModel)objectField);
        this._objectLayoutColumnPersistence.removeByObjectFieldId(objectField.getObjectFieldId());
        if (Objects.equals(objectDefinition.getExtensionDBTableName(), objectField.getDBTableName())) {
            this.runSQL(DynamicObjectDefinitionTable.getAlterTableDropColumnSQL(objectField.getDBTableName(), objectField.getDBColumnName()));
        }
        return objectField;
    }

    public ObjectField fetchObjectField(long objectDefinitionId, String name) {
        return this.objectFieldPersistence.fetchByODI_N(objectDefinitionId, name);
    }

    public ObjectField getObjectField(long objectDefinitionId, String name) throws PortalException {
        return this.objectFieldPersistence.findByODI_N(objectDefinitionId, name);
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId) {
        return this.objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId, String dbTableName) {
        return this.objectFieldPersistence.findByODI_DTN(objectDefinitionId, dbTableName);
    }

    public int getObjectFieldsCount(long objectDefinitionId) {
        return this.objectFieldPersistence.countByObjectDefinitionId(objectDefinitionId);
    }

    public int getObjectFieldsCountByListTypeDefinitionId(long listTypeDefinitionId) {
        return this.objectFieldPersistence.countByListTypeDefinitionId(listTypeDefinitionId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField updateCustomObjectField(long objectFieldId, long listTypeDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectField.getObjectDefinitionId());
        if (objectDefinition.isSystem()) {
            throw new ObjectDefinitionStatusException();
        }
        this._validateLabel(labelMap);
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        if (objectDefinition.isApproved()) {
            return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
        }
        this._validateIndexed(dbType, indexed, indexedAsKeyword, indexedLanguageId);
        if (Validator.isNotNull((String)objectField.getRelationshipType())) {
            if (!Objects.equals(objectField.getDBType(), dbType) || !Objects.equals(objectField.getName(), name)) {
                throw new ObjectFieldRelationshipTypeException("Object field relationship name and DB type cannot be changed");
            }
        } else {
            this._validateBusinessType(businessType);
            this.validateDBType(dbType);
            this._validateName(objectFieldId, objectDefinition, name);
        }
        objectField.setListTypeDefinitionId(listTypeDefinitionId);
        objectField.setBusinessType(businessType);
        objectField.setDBColumnName(name + "_");
        objectField.setDBType(dbType);
        objectField.setIndexed(indexed);
        objectField.setIndexedAsKeyword(indexedAsKeyword);
        objectField.setIndexedLanguageId(indexedLanguageId);
        objectField.setName(name);
        objectField.setRequired(required);
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
    }

    public void validateDBType(String dbType) throws PortalException {
        if (!this._dbTypes.contains(dbType)) {
            throw new ObjectFieldDBTypeException("Invalid DB type " + dbType);
        }
    }

    private ObjectField _addObjectField(long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateBusinessType(businessType);
        this.validateDBType(dbType);
        this._validateIndexed(dbType, indexed, indexedAsKeyword, indexedLanguageId);
        this._validateLabel(labelMap);
        this._validateName(0L, objectDefinition, name);
        ObjectField objectField = this.objectFieldPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectField.setCompanyId(user.getCompanyId());
        objectField.setUserId(user.getUserId());
        objectField.setUserName(user.getFullName());
        objectField.setListTypeDefinitionId(listTypeDefinitionId);
        objectField.setObjectDefinitionId(objectDefinitionId);
        objectField.setBusinessType(businessType);
        objectField.setDBColumnName(dbColumnName);
        objectField.setDBTableName(dbTableName);
        objectField.setDBType(dbType);
        objectField.setIndexed(indexed);
        objectField.setIndexedAsKeyword(indexedAsKeyword);
        objectField.setIndexedLanguageId(indexedLanguageId);
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectField.setName(name);
        objectField.setRelationshipType(null);
        objectField.setRequired(required);
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
    }

    private void _validateBusinessType(String businessType) throws PortalException {
        if (Validator.isNotNull((String)businessType) && !this._businessTypes.contains(businessType)) {
            throw new ObjectFieldBusinessTypeException("Invalid business type " + businessType);
        }
    }

    private void _validateIndexed(String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId) throws PortalException {
        if (indexed && Objects.equals(dbType, "Blob")) {
            throw new ObjectFieldDBTypeException("Blob type is not indexable");
        }
        if (!(Objects.equals(dbType, "String") && !indexedAsKeyword || Validator.isBlank((String)indexedLanguageId))) {
            throw new ObjectFieldDBTypeException("Indexed language ID can only be applied with type \"String\" that is not indexed as a keyword");
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectFieldLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateName(long objectFieldId, ObjectDefinition objectDefinition, String name) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectFieldNameException.MustNotBeNull();
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectFieldNameException.MustOnlyContainLettersAndDigits();
        }
        if (!Character.isLowerCase(nameCharArray[0])) {
            throw new ObjectFieldNameException.MustBeginWithLowerCaseLetter();
        }
        if (nameCharArray.length > 41) {
            throw new ObjectFieldNameException.MustBeLessThan41Characters();
        }
        if (this._reservedNames.contains(StringUtil.toLowerCase((String)name)) || StringUtil.equalsIgnoreCase((String)objectDefinition.getPKObjectFieldName(), (String)name)) {
            throw new ObjectFieldNameException.MustNotBeReserved(name);
        }
        ObjectField objectField = this.objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), name);
        if (objectField != null && objectField.getObjectFieldId() != objectFieldId) {
            throw new ObjectFieldNameException.MustNotBeDuplicate(name);
        }
    }
}

