/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.configuration.ObjectEntryVersionConfiguration;
import com.liferay.object.entry.util.ObjectEntryDTOConverterUtil;
import com.liferay.object.exception.RequiredObjectEntryVersionException;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.base.ObjectEntryVersionLocalServiceBaseImpl;
import com.liferay.object.util.comparator.ObjectEntryVersionCreateDateComparator;
import com.liferay.object.util.comparator.ObjectEntryVersionVersionComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectEntryVersion"}, service={AopService.class})
public class ObjectEntryVersionLocalServiceImpl
extends ObjectEntryVersionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryVersionLocalServiceImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    private volatile ObjectEntryVersionConfiguration _objectEntryVersionConfiguration;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectEntryVersion addObjectEntryVersion(ObjectEntry objectEntry) throws PortalException {
        ObjectEntryVersion oldestObjectEntryVersion;
        ObjectEntryVersion objectEntryVersion = this._updateObjectEntryVersion(objectEntry, this.objectEntryVersionPersistence.create(this.counterLocalService.increment()), objectEntry.getVersion() + 1);
        if (this._exceedsMaximumVersions(objectEntry.getObjectEntryId()) && (oldestObjectEntryVersion = this.objectEntryVersionPersistence.findByObjectEntryId_First(objectEntry.getObjectEntryId(), (OrderByComparator)ObjectEntryVersionCreateDateComparator.getInstance((boolean)true))) != null) {
            this.deleteObjectEntryVersion(objectEntry.getObjectEntryId(), oldestObjectEntryVersion.getVersion());
        }
        return objectEntryVersion;
    }

    public void checkObjectEntryVersions(long companyId) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            return;
        }
        ObjectEntryVersionConfiguration objectEntryVersionConfiguration = (ObjectEntryVersionConfiguration)this._configurationProvider.getCompanyConfiguration(ObjectEntryVersionConfiguration.class, companyId);
        if (objectEntryVersionConfiguration.maximumRetentionPeriod() <= 0) {
            return;
        }
        Date endDate = Date.from(LocalDate.now().minusMonths(objectEntryVersionConfiguration.maximumRetentionPeriod()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            dynamicQuery.add(companyIdProperty.eq((Object)companyId));
            Property createDateProperty = PropertyFactoryUtil.forName((String)"createDate");
            dynamicQuery.add(createDateProperty.lt((Object)endDate));
        });
        actionableDynamicQuery.setPerformActionMethod(objectEntryVersion -> {
            block3: {
                try {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Deleting object entry version " + objectEntryVersion.getObjectEntryVersionId()));
                    }
                    this.deleteObjectEntryVersion(objectEntryVersion.getObjectEntryId(), objectEntryVersion.getVersion());
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)("Unable to delete object entry version " + objectEntryVersion.getObjectEntryVersionId()), (Throwable)portalException);
                }
            }
        });
        actionableDynamicQuery.setTransactionConfig(DefaultActionableDynamicQuery.REQUIRES_NEW_TRANSACTION_CONFIG);
        actionableDynamicQuery.performActions();
    }

    public ObjectEntryVersion deleteObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        if (this.getObjectEntryVersionsCount(objectEntryId) == 1) {
            throw new RequiredObjectEntryVersionException.MustHaveOneVersion("At least one version must remain", "at-least-one-version-must-remain");
        }
        ObjectEntryVersion objectEntryVersion = this.objectEntryVersionPersistence.fetchByObjectEntryId_First(objectEntryId, (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false));
        if (version == objectEntryVersion.getVersion()) {
            throw new RequiredObjectEntryVersionException.MustNotDeleteLatestVersion("The latest version cannot be deleted", "the-last-version-cannot-be-deleted");
        }
        objectEntryVersion = this.objectEntryVersionPersistence.findByOEI_V(objectEntryId, version);
        return this.deleteObjectEntryVersion(objectEntryVersion);
    }

    public void deleteObjectEntryVersionByObjectDefinitionId(Long objectDefinitionId) {
        this.objectEntryVersionPersistence.removeByObjectDefinitionId(objectDefinitionId.longValue());
    }

    public void deleteObjectEntryVersions(long objectEntryId) {
        this.objectEntryVersionPersistence.removeByObjectEntryId(objectEntryId);
    }

    public ObjectEntryVersion expireObjectEntryVersion(long userId, ObjectEntry objectEntry, int version, ServiceContext serviceContext) throws PortalException {
        return this._expireObjectEntryVersion(userId, this.objectEntryVersionPersistence.findByOEI_V(objectEntry.getObjectEntryId(), version));
    }

    public ObjectEntryVersion expireObjectEntryVersion(long userId, ObjectEntryVersion objectEntryVersion) throws PortalException {
        return this._expireObjectEntryVersion(userId, objectEntryVersion);
    }

    public void expireObjectEntryVersions(long userId, ObjectEntry objectEntry, ServiceContext serviceContext) throws Exception {
        for (ObjectEntryVersion objectEntryVersion : this.getObjectEntryVersions(objectEntry.getObjectEntryId())) {
            this.expireObjectEntryVersion(userId, objectEntry, objectEntryVersion.getVersion(), serviceContext);
        }
    }

    public ObjectEntryVersion fetchLatestApprovedObjectEntryVersion(long objectEntryId, OrderByComparator<ObjectEntryVersion> orderByComparator) {
        return this.objectEntryVersionPersistence.fetchByOEI_S_First(objectEntryId, 0, orderByComparator);
    }

    public ObjectEntryVersion fetchObjectEntryVersion(long objectEntryId, int version) {
        return this.objectEntryVersionPersistence.fetchByOEI_V(objectEntryId, version);
    }

    public ObjectEntryVersion getObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        return this.objectEntryVersionPersistence.findByOEI_V(objectEntryId, version);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId) {
        return this.objectEntryVersionPersistence.findByObjectEntryId(objectEntryId);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId, int start, int end) {
        return this.objectEntryVersionPersistence.findByObjectEntryId(objectEntryId, start, end);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId, int start, int end, OrderByComparator<ObjectEntryVersion> orderByComparator) {
        return this.objectEntryVersionPersistence.findByObjectEntryId(objectEntryId, start, end, orderByComparator);
    }

    public int getObjectEntryVersionsCount(long objectEntryId) {
        return this.objectEntryVersionPersistence.countByObjectEntryId(objectEntryId);
    }

    public boolean isLatestObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        ObjectEntryVersion objectEntryVersion = this._getLatestObjectEntryVersion(objectEntryId);
        return version == objectEntryVersion.getVersion();
    }

    public ObjectEntryVersion updateLatestObjectEntryVersion(ObjectEntry objectEntry) throws PortalException {
        return this._updateObjectEntryVersion(objectEntry, this.objectEntryVersionPersistence.fetchByObjectEntryId_First(objectEntry.getObjectEntryId(), (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false)), objectEntry.getVersion());
    }

    public ObjectEntryVersion updateLatestObjectEntryVersionModifiedDate(Date modifiedDate, long objectEntryId) throws PortalException {
        ObjectEntryVersion objectEntryVersion = this.objectEntryVersionPersistence.findByObjectEntryId_First(objectEntryId, (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false));
        objectEntryVersion.setModifiedDate(modifiedDate);
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }

    private boolean _exceedsMaximumVersions(long objectEntryId) {
        boolean exceedsMaximumVersions = false;
        int count = this.getObjectEntryVersionsCount(objectEntryId);
        if (count <= 0) {
            return exceedsMaximumVersions;
        }
        try {
            this._objectEntryVersionConfiguration = (ObjectEntryVersionConfiguration)this._configurationProvider.getCompanyConfiguration(ObjectEntryVersionConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            if (this._objectEntryVersionConfiguration == null) {
                this._objectEntryVersionConfiguration = (ObjectEntryVersionConfiguration)this._configurationProvider.getSystemConfiguration(ObjectEntryVersionConfiguration.class);
            }
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException);
        }
        int maximumVersionsPerEntry = this._objectEntryVersionConfiguration.maximumVersionsPerEntry();
        if (maximumVersionsPerEntry > 0 && count > maximumVersionsPerEntry) {
            exceedsMaximumVersions = true;
        }
        return exceedsMaximumVersions;
    }

    private ObjectEntryVersion _expireObjectEntryVersion(long userId, ObjectEntryVersion objectEntryVersion) throws PortalException {
        if (objectEntryVersion.isDraft() || objectEntryVersion.isExpired() || objectEntryVersion.isPending()) {
            return objectEntryVersion;
        }
        Date date = new Date();
        objectEntryVersion.setExpirationDate(date);
        objectEntryVersion.setStatus(3);
        User user = this._userLocalService.getUser(userId);
        objectEntryVersion.setStatusByUserId(user.getUserId());
        objectEntryVersion.setStatusByUserName(user.getFullName());
        objectEntryVersion.setStatusDate(date);
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }

    private ObjectEntryVersion _getLatestObjectEntryVersion(long objectEntryId) throws PortalException {
        return this.objectEntryVersionPersistence.findByObjectEntryId_First(objectEntryId, (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false));
    }

    private ObjectEntryVersion _updateObjectEntryVersion(ObjectEntry objectEntry, ObjectEntryVersion objectEntryVersion, int version) throws PortalException {
        User user = this._userLocalService.getUser(objectEntry.getUserId());
        objectEntryVersion.setUserId(user.getUserId());
        objectEntryVersion.setUserName(user.getFullName());
        objectEntryVersion.setCreateDate(objectEntry.getCreateDate());
        objectEntryVersion.setModifiedDate(objectEntry.getModifiedDate());
        objectEntryVersion.setObjectDefinitionId(objectEntry.getObjectDefinitionId());
        objectEntryVersion.setObjectEntryId(objectEntry.getObjectEntryId());
        try {
            objectEntryVersion.setContent(ObjectEntryDTOConverterUtil.toDTO((DTOConverterRegistry)this._dtoConverterRegistry, (JSONFactory)this._jsonFactory, (ObjectEntry)objectEntry, (User)user));
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPD-17564")) {
            objectEntryVersion.setDisplayDate(objectEntry.getDisplayDate());
        }
        Date date = new Date();
        Date expirationDate = objectEntryVersion.getExpirationDate();
        int status = objectEntry.getStatus();
        if (status == 0 && expirationDate != null && expirationDate.before(date)) {
            objectEntryVersion.setExpirationDate(null);
        }
        if (status == 3 && expirationDate == null) {
            objectEntryVersion.setExpirationDate(date);
        }
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPD-17564")) {
            objectEntryVersion.setReviewDate(objectEntry.getReviewDate());
        }
        objectEntryVersion.setVersion(version);
        objectEntryVersion.setStatus(status);
        objectEntryVersion.setStatusByUserId(user.getUserId());
        objectEntryVersion.setStatusByUserName(user.getFullName());
        objectEntryVersion.setStatusDate(date);
        return (ObjectEntryVersion)this.objectEntryVersionPersistence.update((BaseModel)objectEntryVersion);
    }
}

