/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ObjectRelationshipLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ObjectRelationshipLocalService {
    protected ObjectRelationshipLocalService objectRelationshipLocalService;
    @Reference
    protected ObjectRelationshipPersistence objectRelationshipPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ObjectRelationshipLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship addObjectRelationship(ObjectRelationship objectRelationship) {
        objectRelationship.setNew(true);
        return (ObjectRelationship)this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
    }

    @Transactional(enabled=false)
    public ObjectRelationship createObjectRelationship(long objectRelationshipId) {
        return this.objectRelationshipPersistence.create(objectRelationshipId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectRelationship deleteObjectRelationship(long objectRelationshipId) throws PortalException {
        return this.objectRelationshipPersistence.remove(objectRelationshipId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectRelationship deleteObjectRelationship(ObjectRelationship objectRelationship) throws PortalException {
        return (ObjectRelationship)this.objectRelationshipPersistence.remove((BaseModel)objectRelationship);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.objectRelationshipPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(ObjectRelationship.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.objectRelationshipPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.objectRelationshipPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.objectRelationshipPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.objectRelationshipPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.objectRelationshipPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public ObjectRelationship fetchObjectRelationship(long objectRelationshipId) {
        return this.objectRelationshipPersistence.fetchByPrimaryKey(objectRelationshipId);
    }

    public ObjectRelationship fetchObjectRelationshipByUuidAndCompanyId(String uuid, long companyId) {
        return this.objectRelationshipPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public ObjectRelationship getObjectRelationship(long objectRelationshipId) throws PortalException {
        return this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectRelationshipLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectRelationship.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectRelationshipId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectRelationshipLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(ObjectRelationship.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("objectRelationshipId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectRelationshipLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectRelationship.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectRelationshipId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ObjectRelationship>(){

            public void performAction(ObjectRelationship objectRelationship) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)objectRelationship);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)ObjectRelationship.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.objectRelationshipPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement ObjectRelationshipLocalServiceImpl#deleteObjectRelationship(ObjectRelationship) to avoid orphaned data");
        }
        return this.objectRelationshipLocalService.deleteObjectRelationship((ObjectRelationship)persistedModel);
    }

    public BasePersistence<ObjectRelationship> getBasePersistence() {
        return this.objectRelationshipPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.objectRelationshipPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public ObjectRelationship getObjectRelationshipByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.objectRelationshipPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<ObjectRelationship> getObjectRelationships(int start, int end) {
        return this.objectRelationshipPersistence.findAll(start, end);
    }

    public int getObjectRelationshipsCount() {
        return this.objectRelationshipPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship updateObjectRelationship(ObjectRelationship objectRelationship) {
        return (ObjectRelationship)this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ObjectRelationshipLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.objectRelationshipLocalService = (ObjectRelationshipLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return ObjectRelationshipLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return ObjectRelationship.class;
    }

    protected String getModelClassName() {
        return ObjectRelationship.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.objectRelationshipPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

