/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.validation.rule;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.object.dynamic.data.mapping.expression.ObjectEntryDDMExpressionFieldAccessor;
import com.liferay.object.internal.dynamic.data.mapping.expression.ObjectEntryDDMExpressionParameterAccessor;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectValidationRuleEngine.class})
public class DDMObjectValidationRuleEngineImpl
implements ObjectValidationRuleEngine {
    private static final Log _log = LogFactoryUtil.getLog(DDMObjectValidationRuleEngineImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private Language _language;

    public Map<String, Object> execute(Map<String, Object> inputObjects, String script) {
        HashMap results = HashMapBuilder.put((Object)"invalidScript", (Object)false).put((Object)"validationCriteriaMet", (Object)true).build();
        try {
            DDMExpression ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).withDDMExpressionFieldAccessor((DDMExpressionFieldAccessor)new ObjectEntryDDMExpressionFieldAccessor((Map)inputObjects.get("baseModel"))).withDDMExpressionParameterAccessor((DDMExpressionParameterAccessor)new ObjectEntryDDMExpressionParameterAccessor((Map)inputObjects.get("originalBaseModel"))).build());
            ddmExpression.setVariables((Map)inputObjects.get("baseModel"));
            results.put("validationCriteriaMet", ddmExpression.evaluate());
        }
        catch (DDMExpressionException ddmExpressionException) {
            _log.error((Throwable)ddmExpressionException);
            results.put("invalidScript", true);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            results.put("validationCriteriaMet", false);
        }
        return results;
    }

    public String getKey() {
        return "ddm";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, this.getKey());
    }
}

