/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v10_15_0;

import com.liferay.friendly.url.configuration.manager.FriendlyURLSeparatorConfigurationManager;
import com.liferay.object.model.ObjectEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ObjectDefinitionUpgradeProcess
extends UpgradeProcess {
    private final FriendlyURLSeparatorConfigurationManager _friendlyURLSeparatorConfigurationManager;

    public ObjectDefinitionUpgradeProcess(FriendlyURLSeparatorConfigurationManager friendlyURLSeparatorConfigurationManager) {
        this._friendlyURLSeparatorConfigurationManager = friendlyURLSeparatorConfigurationManager;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select companyId, objectDefinitionId from ", "ObjectDefinition where friendlyURLSeparator is null ", "and modifiable = [$TRUE$] and storageType = ?"})));){
            preparedStatement1.setString(1, "default");
            try (PreparedStatement preparedStatement2 = this.connection.prepareStatement("update ObjectDefinition set friendlyURLSeparator = ? where objectDefinitionId = ?");
                 ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    JSONObject friendlyURLSeparatorsJSONObject = this._friendlyURLSeparatorConfigurationManager.getFriendlyURLSeparatorsJSONObject(resultSet.getLong("companyId"));
                    String friendlyURLSeparator = friendlyURLSeparatorsJSONObject.getString(ObjectEntry.class.getName());
                    if (Validator.isNull((String)friendlyURLSeparator)) {
                        friendlyURLSeparator = "/l/";
                    }
                    preparedStatement2.setString(1, StringUtil.removeSubstring((String)friendlyURLSeparator, (String)"/"));
                    preparedStatement2.setLong(2, resultSet.getLong("objectDefinitionId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"ObjectDefinition", (String[])new String[]{"friendlyURLSeparator VARCHAR(75) null"})};
    }
}

