/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectDefinitionModel;
import com.liferay.object.model.ObjectDefinitionSetting;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectDefinitionSettingLocalService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseModelListener<T extends BaseModel<T>>
extends com.liferay.portal.kernel.model.BaseModelListener<T> {
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected ObjectDefinitionLocalService objectDefinitionLocalService;
    @Reference
    protected ObjectDefinitionSettingLocalService objectDefinitionSettingLocalService;
    private static final Pattern _classNamePattern = Pattern.compile("(com\\.liferay\\.object\\.model\\.ObjectDefinition#)([a-zA-Z]\\d[a-zA-Z]\\d)");
    private static final Pattern _jsonClassNameIdPattern = Pattern.compile("(\"classNameId\"\\s*:\\s*\")(\\d+)(\")");
    private static final Pattern _portletIdPattern = Pattern.compile("(com_liferay_object_web_internal_object_definitions_portlet_ObjectDefinitionsPortlet_)([a-zA-Z]\\d[a-zA-Z]\\d)");

    protected long updateObjectDefinitionClassNameId(long classNameId) {
        ObjectDefinition objectDefinition = this._getObjectDefinition("oldClassNameId", String.valueOf(classNameId));
        if (objectDefinition == null) {
            return classNameId;
        }
        return this.classNameLocalService.getClassNameId(objectDefinition.getClassName());
    }

    protected String updateObjectDefinitionReferences(String value) {
        value = this._updateObjectDefinitionReferences(ObjectDefinitionModel::getClassName, _classNamePattern, value);
        value = this._updateObjectDefinitionReferences(ObjectDefinition::getPortletId, _portletIdPattern, value);
        return this._updateObjectDefinitionJSONClassNameId(value);
    }

    private ObjectDefinition _getObjectDefinition(String objectDefinitionSettingName, String objectDefinitionSettingValue) {
        ObjectDefinitionSetting objectDefinitionSetting = this.objectDefinitionSettingLocalService.fetchObjectDefinitionSetting(CompanyThreadLocal.getCompanyId().longValue(), objectDefinitionSettingName, objectDefinitionSettingValue);
        if (objectDefinitionSetting == null) {
            return null;
        }
        return this.objectDefinitionLocalService.fetchObjectDefinition(objectDefinitionSetting.getObjectDefinitionId());
    }

    private String _updateObjectDefinitionJSONClassNameId(String json) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = _jsonClassNameIdPattern.matcher(json);
        while (matcher.find()) {
            ObjectDefinition objectDefinition = this._getObjectDefinition("oldClassNameId", matcher.group(2));
            if (objectDefinition == null) continue;
            long classNameId = this.classNameLocalService.getClassNameId(objectDefinition.getClassName());
            matcher.appendReplacement(sb, Matcher.quoteReplacement(matcher.group(1) + classNameId + matcher.group(3)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String _updateObjectDefinitionReferences(Function<ObjectDefinition, String> function, Pattern pattern, String value) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            ObjectDefinition objectDefinition = this._getObjectDefinition("oldClassName", "com.liferay.object.model.ObjectDefinition#" + matcher.group(2));
            if (objectDefinition == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(function.apply(objectDefinition)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

