/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    protected DDMExpressionFactory ddmExpressionFactory;
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    protected ObjectFieldSettingLocalService objectFieldSettingLocalService;

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return HashMapBuilder.put((Object)"predefinedValue", () -> {
            LocalizedValue localizedValue = new LocalizedValue(objectFieldRenderingContext.getLocale());
            Locale defaultLocale = objectFieldRenderingContext.getLocale();
            String defaultValue = Objects.toString(ObjectFieldSettingUtil.getDefaultValue((DDMExpressionFactory)this.ddmExpressionFactory, (ObjectField)objectField, null), "");
            if (objectField.isLocalized() && Validator.isNotNull((String)defaultValue)) {
                localizedValue.addString(defaultLocale, this.jsonFactory.createJSONObject((Map)HashMapBuilder.put((Object)defaultLocale, (Object)defaultValue).build()).toJSONString());
            } else {
                localizedValue.addString(defaultLocale, defaultValue);
            }
            return localizedValue;
        }).putAll(this.getObjectFieldSettingsValues(this.objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField))).putAll(super.getProperties(objectField, objectFieldRenderingContext)).build();
    }

    protected Map<String, String> getObjectFieldSettingsValues(List<ObjectFieldSetting> objectFieldSettings) {
        HashMap<String, String> objectFieldSettingsValues = new HashMap<String, String>();
        ListUtil.isNotEmptyForEach(objectFieldSettings, objectFieldSetting -> objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return objectFieldSettingsValues;
    }

    protected void validateBooleanObjectFieldSetting(String objectFieldName, String objectFieldSettingName, Map<String, String> objectFieldSettingsValues) throws PortalException {
        String objectFieldSettingValue = objectFieldSettingsValues.get(objectFieldSettingName);
        if (Validator.isNotNull((String)objectFieldSettingValue) && !StringUtil.equalsIgnoreCase((String)objectFieldSettingValue, (String)"false") && !StringUtil.equalsIgnoreCase((String)objectFieldSettingValue, (String)"true")) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, objectFieldSettingName, objectFieldSettingValue);
        }
    }

    protected void validateMaxLength(int maxLength, String objectFieldSettingName, String objectFieldSettingValue) throws PortalException {
        if (objectFieldSettingValue != null && objectFieldSettingValue.length() > maxLength) {
            throw new ObjectFieldSettingValueException.ExceedsMaxLength(maxLength, objectFieldSettingName);
        }
    }

    protected void validateNotAllowedObjectFieldSettingNames(Set<String> notAllowedObjectFieldSettingNames, String objectFieldName, Map<String, String> objectFieldSettingsValues) throws PortalException {
        for (String notAllowedObjectFieldSettingName : new HashSet<String>(notAllowedObjectFieldSettingNames)) {
            if (objectFieldSettingsValues.containsKey(notAllowedObjectFieldSettingName)) continue;
            notAllowedObjectFieldSettingNames.remove(notAllowedObjectFieldSettingName);
        }
        if (!notAllowedObjectFieldSettingNames.isEmpty()) {
            throw new ObjectFieldSettingNameException.NotAllowedNames(objectFieldName, notAllowedObjectFieldSettingNames);
        }
    }

    protected void validateRelatedObjectFieldSettings(ObjectField objectField, String objectFieldSettingName1, String objectFieldSettingName2, Map<String, String> objectFieldSettingsValues) throws PortalException {
        this.validateBooleanObjectFieldSetting(objectField.getName(), objectFieldSettingName1, objectFieldSettingsValues);
        if (StringUtil.equalsIgnoreCase((String)objectFieldSettingsValues.get(objectFieldSettingName1), (String)"true")) {
            this._validateObjectFieldSettingValue(objectField, objectFieldSettingName2, objectFieldSettingsValues);
        } else {
            this.validateNotAllowedObjectFieldSettingNames(SetUtil.fromArray((Object[])new String[]{objectFieldSettingName2}), objectField.getName(), objectFieldSettingsValues);
        }
    }

    private void _validateObjectFieldSettingValue(ObjectField objectField, String objectFieldSettingName, Map<String, String> objectFieldSettingsValues) throws PortalException {
        String objectFieldSettingValue = objectFieldSettingsValues.get(objectFieldSettingName);
        if (Validator.isNull((String)objectFieldSettingValue)) {
            throw new ObjectFieldSettingValueException.MissingRequiredValues(objectField.getName(), Collections.singleton(objectFieldSettingName));
        }
        if (Objects.equals(objectFieldSettingName, "maxLength")) {
            int maxLength = GetterUtil.getInteger((String)objectFieldSettingValue);
            int limitMaxLength = 280;
            if (objectField.compareBusinessType("LongText")) {
                limitMaxLength = 65000;
            }
            if (maxLength < 1 || maxLength > limitMaxLength) {
                throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "maxLength", objectFieldSettingValue);
            }
        } else if (Objects.equals(objectFieldSettingName, "storageDLFolderPath")) {
            this.validateMaxLength(255, objectFieldSettingName, objectFieldSettingValue);
            for (String directoryName : StringUtil.split((String)objectFieldSettingValue, (char)'/')) {
                DLValidatorUtil.validateDirectoryName((String)directoryName);
            }
        }
    }
}

