/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.depot.model.DepotEntry;
import com.liferay.object.internal.bulk.selection.BaseObjectBulkSelectionAction;
import com.liferay.object.internal.entry.folder.util.ObjectEntryFolderUtil;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.PermissionService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=permission.object"}, service={BulkSelectionAction.class})
public class PermissionObjectBulkSelectionAction
extends BaseObjectBulkSelectionAction {
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    @Reference
    private PermissionService _permissionService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    @Override
    protected void doExecute(User user, Map<String, Serializable> inputMap, Object object) throws Exception {
        String className = null;
        long companyId = 0L;
        long groupId = 0L;
        long resourceId = 0L;
        String resourceName = null;
        if (object instanceof DepotEntry) {
            DepotEntry depotEntry = (DepotEntry)object;
            className = depotEntry.getModelClassName();
            companyId = depotEntry.getCompanyId();
            groupId = depotEntry.getGroupId();
            resourceId = depotEntry.getDepotEntryId();
            resourceName = depotEntry.getModelClassName();
        } else if (object instanceof ObjectEntry) {
            ObjectEntry objectObjectEntry = (ObjectEntry)object;
            long rootObjectEntryFolderId = ObjectEntryFolderUtil.getRootObjectEntryFolderId(objectObjectEntry.getObjectEntryFolderId());
            if (rootObjectEntryFolderId == 0L) {
                return;
            }
            ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.getObjectEntryFolder(rootObjectEntryFolderId);
            className = objectEntryFolder.getExternalReferenceCode();
            companyId = objectObjectEntry.getCompanyId();
            groupId = objectObjectEntry.getGroupId();
            resourceId = objectObjectEntry.getObjectEntryId();
            resourceName = objectObjectEntry.getModelClassName();
        } else {
            ObjectEntryFolder objectEntryFolder = (ObjectEntryFolder)object;
            className = objectEntryFolder.getModelClassName();
            companyId = objectEntryFolder.getCompanyId();
            groupId = objectEntryFolder.getGroupId();
            resourceId = objectEntryFolder.getObjectEntryFolderId();
            resourceName = objectEntryFolder.getModelClassName();
        }
        this._permissionService.checkPermission(groupId, resourceName, resourceId);
        ModelPermissions modelPermissions = ModelPermissionsUtil.toModelPermissions((long)companyId, (Permission[])this._getPermissions((Map)((Object)inputMap.get("permissions")), className), (long)resourceId, (String)resourceName, (ResourceActionLocalService)this._resourceActionLocalService, (ResourcePermissionLocalService)this._resourcePermissionLocalService, (RoleLocalService)this._roleLocalService);
        String roleKey = (String)((Object)inputMap.get("roleKey"));
        if (Validator.isBlank((String)roleKey)) {
            Collection roleNames = modelPermissions.getRoleNames();
            for (ResourcePermission resourcePermission : this._resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId))) {
                Role role = this._roleLocalService.fetchRole(resourcePermission.getRoleId());
                if (role == null || roleNames.contains(role.getName())) continue;
                for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(resourceName)) {
                    this._resourcePermissionLocalService.removeResourcePermission(companyId, resourceName, 4, String.valueOf(resourceId), role.getRoleId(), resourceAction.getActionId());
                }
            }
            this._resourcePermissionLocalService.updateResourcePermissions(companyId, groupId, resourceName, String.valueOf(resourceId), modelPermissions);
        } else {
            Role role = this._roleLocalService.fetchRole(companyId, roleKey);
            if (role != null) {
                this._resourcePermissionLocalService.setResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId), role.getRoleId(), modelPermissions.getActionIds(role.getName()));
            }
        }
    }

    private Permission[] _getPermissions(Map<String, Serializable> map, String key) {
        return (Permission[])map.getOrDefault(key, (Serializable)new Permission[0]);
    }
}

