/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.object.model.ObjectEntry;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.io.Serializable;
import java.util.Map;

public class ObjectAssetEntryBulkSelection
implements BulkSelection<AssetEntry> {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final BulkSelection<Object> _objectBulkSelection;

    public ObjectAssetEntryBulkSelection(AssetEntryLocalService assetEntryLocalService, BulkSelection<Object> objectBulkSelection) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._objectBulkSelection = objectBulkSelection;
    }

    public <E extends PortalException> void forEach(UnsafeConsumer<AssetEntry, E> unsafeConsumer) throws PortalException {
        this._objectBulkSelection.forEach(object -> unsafeConsumer.accept((Object)this._toAssetEntry(object)));
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return this._objectBulkSelection.getBulkSelectionFactoryClass();
    }

    public Map<String, String[]> getParameterMap() {
        return this._objectBulkSelection.getParameterMap();
    }

    public long getSize() throws PortalException {
        return this._objectBulkSelection.getSize();
    }

    public Serializable serialize() {
        return this._objectBulkSelection.serialize();
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        return this;
    }

    private AssetEntry _toAssetEntry(Object object) {
        try {
            ObjectEntry objectObjectEntry = (ObjectEntry)object;
            return this._assetEntryLocalService.getEntry(objectObjectEntry.getModelClassName(), objectObjectEntry.getObjectEntryId());
        }
        catch (PortalException portalException) {
            return (AssetEntry)ReflectionUtil.throwException((Throwable)portalException);
        }
    }
}

