/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.object.internal.bulk.selection.BaseObjectBulkSelectionAction;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=expire.object"}, service={BulkSelectionAction.class})
public class ExpireObjectBulkSelectionAction
extends BaseObjectBulkSelectionAction {
    @Reference
    private ObjectEntryService _objectEntryService;

    @Override
    protected void doExecute(User user, Map<String, Serializable> inputMap, Object object) throws Exception {
        if (!(object instanceof ObjectEntry)) {
            if (object instanceof ObjectEntryFolder) {
                ObjectEntryFolder objectEntryFolder = (ObjectEntryFolder)object;
                throw new IllegalArgumentException("Object entry folders do not support expiration " + String.valueOf(objectEntryFolder));
            }
            throw new IllegalArgumentException("Unsupported object " + String.valueOf(object));
        }
        ObjectEntry objectObjectEntry = (ObjectEntry)object;
        this._objectEntryService.expireObjectEntry(objectObjectEntry.getObjectEntryId(), new ServiceContext());
    }
}

