/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.util;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryOrganizationRelLocalServiceUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;

public class ObjectEntryPermissionUtil {
    public static Predicate getPermissionWherePredicate(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long groupId, InlineSQLHelper inlineSQLHelper) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return null;
        }
        ObjectDefinition objectDefinition = dynamicObjectDefinitionTable.getObjectDefinition();
        if (!inlineSQLHelper.isEnabled(objectDefinition.getCompanyId(), groupId)) {
            return null;
        }
        return inlineSQLHelper.getPermissionWherePredicate(objectDefinition.getClassName(), dynamicObjectDefinitionTable.getPrimaryKeyColumn(), new long[]{groupId});
    }

    public static boolean hasAccountEntryPermission(AccountEntry accountEntry, String actionId, String name, PermissionChecker permissionChecker) throws PortalException {
        if (permissionChecker.hasPermission(accountEntry.getAccountEntryGroupId(), name, 0L, actionId)) {
            return true;
        }
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : AccountEntryOrganizationRelLocalServiceUtil.getAccountEntryOrganizationRels((long)accountEntry.getAccountEntryId())) {
            Organization organization = accountEntryOrganizationRel.getOrganization();
            if (permissionChecker.hasPermission(organization.getGroupId(), name, 0L, actionId)) {
                return true;
            }
            for (Organization ancestorOrganization : organization.getAncestors()) {
                if (!permissionChecker.hasPermission(ancestorOrganization.getGroupId(), name, 0L, actionId)) continue;
                return true;
            }
        }
        return false;
    }
}

