/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.object.internal.bulk.selection.BaseObjectBulkSelectionAction;
import com.liferay.object.model.ObjectEntry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=edit.object.categories"}, service={BulkSelectionAction.class})
public class EditObjectCategoriesBulkSelectionAction
extends BaseObjectBulkSelectionAction {
    private static final Log _log = LogFactoryUtil.getLog(EditObjectCategoriesBulkSelectionAction.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;

    @Override
    protected void doExecute(User user, Map<String, Serializable> inputMap, Object object) throws Exception {
        if (!(object instanceof ObjectEntry)) {
            return;
        }
        ObjectEntry objectEntry = (ObjectEntry)object;
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(objectEntry.getModelClassName(), objectEntry.getObjectEntryId());
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        if (assetEntry == null || !ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE").booleanValue()) {
            return;
        }
        long[] newCategoryIds = new long[]{};
        Set<Long> toAddCategoryIds = this._toLongSet(inputMap, "toAddCategoryIds");
        if (SetUtil.isNotEmpty(toAddCategoryIds)) {
            newCategoryIds = ArrayUtil.toLongArray(toAddCategoryIds);
        }
        if (MapUtil.getBoolean(inputMap, (String)"append")) {
            Set currentCategoryIds = SetUtil.fromArray((long[])assetEntry.getCategoryIds());
            Set<Long> toRemoveCategoryIds = this._toLongSet(inputMap, "toRemoveCategoryIds");
            currentCategoryIds.removeAll(toRemoveCategoryIds);
            currentCategoryIds.addAll(toAddCategoryIds);
            newCategoryIds = ArrayUtil.toLongArray((Collection)currentCategoryIds);
        }
        this._assetEntryLocalService.updateEntry(assetEntry.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK(), newCategoryIds, assetEntry.getTagNames());
    }

    private Set<Long> _toLongSet(Map<String, Serializable> map, String key) {
        try {
            Serializable values = map.get(key);
            if (values instanceof Long[]) {
                return SetUtil.fromArray((Object[])((Long[])values));
            }
            HashSet<Long> set = new HashSet<Long>();
            for (Integer value : (Integer[])values) {
                set.add(value.longValue());
            }
            return set;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return SetUtil.fromArray((Object[])new Long[0]);
        }
    }
}

