/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.object.internal.bulk.selection.BaseObjectBulkSelectionAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.trash.TrashHelper;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=delete.object"}, service={BulkSelectionAction.class})
public class DeleteObjectBulkSelectionAction
extends BaseObjectBulkSelectionAction {
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private TrashHelper _trashHelper;

    @Override
    protected void doExecute(User user, Map<String, Serializable> inputMap, Object object) throws Exception {
        if (object instanceof ObjectEntry) {
            ObjectEntry objectObjectEntry = (ObjectEntry)object;
            ObjectDefinition objectDefinition = this.objectDefinitionLocalService.getObjectDefinition(objectObjectEntry.getObjectDefinitionId());
            DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getCompanyId(), objectDefinition.getStorageType()));
            defaultObjectEntryManager.deleteObjectEntry(objectDefinition, objectObjectEntry.getObjectEntryId());
        } else {
            ObjectEntryFolder objectEntryFolder = (ObjectEntryFolder)object;
            this._deleteObjectEntryFolder(user.getUserId(), objectEntryFolder);
        }
    }

    private void _deleteObjectEntryFolder(long userId, ObjectEntryFolder objectEntryFolder) throws Exception {
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntryFolder.getCompanyId(), (String)"LPD-17564") && objectEntryFolder.isTrashable(this._trashHelper)) {
            this._objectEntryFolderLocalService.moveObjectEntryFolderToTrash(userId, objectEntryFolder, new ServiceContext());
        } else {
            this._objectEntryFolderLocalService.deleteObjectEntryFolder(objectEntryFolder.getObjectEntryFolderId());
        }
    }
}

