/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseObjectBulkSelectionAction
implements BulkSelectionAction<Object> {
    @Reference
    protected ObjectDefinitionLocalService objectDefinitionLocalService;
    @Reference
    protected ObjectEntryLocalService objectEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseObjectBulkSelectionAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(User user, BulkSelection<Object> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        long bulkActionTaskId = GetterUtil.getLong((Object)inputMap.get("bulkActionTaskId"));
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(bulkActionTaskId);
        Map values = objectEntry.getValues();
        values.put("numberOfItems", bulkSelection.getSize());
        String executionStatus = "completed";
        AtomicInteger numberOfFailedItems = new AtomicInteger(0);
        AtomicInteger numberOfSuccessfulItems = new AtomicInteger(0);
        try {
            values.put("executionStatus", "started");
            objectEntry = this.partialUpdateObjectEntry(user.getUserId(), objectEntry, values);
            values = objectEntry.getValues();
            long objectDefinitionId = this._getObjectDefinitionId(objectEntry.getCompanyId());
            bulkSelection.forEach(object -> {
                String status = "completed";
                try {
                    this.doExecute(user, inputMap, object);
                    numberOfSuccessfulItems.getAndIncrement();
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)exception);
                    }
                    numberOfFailedItems.getAndIncrement();
                    status = "failed";
                }
                finally {
                    this.objectEntryLocalService.addObjectEntry(0L, user.getUserId(), objectDefinitionId, 0L, null, (Map)HashMapBuilder.put((Object)"bulkActionTaskId", (Object)bulkActionTaskId).put((Object)"executionStatus", (Object)status).put((Object)"r_cmsBATaskToCMSBATaskItems_c_cmsBulkActionTaskId", (Object)bulkActionTaskId).put((Object)"type", (Object)"ObjectEntryFolder").build(), new ServiceContext());
                }
            });
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            executionStatus = "failed";
        }
        finally {
            values.put("completionDate", new Date());
            values.put("executionStatus", executionStatus);
            values.put("numberOfFailedItems", numberOfFailedItems.get());
            values.put("numberOfSuccessfulItems", numberOfSuccessfulItems.get());
            this.partialUpdateObjectEntry(user.getUserId(), objectEntry, values);
        }
    }

    protected abstract void doExecute(User var1, Map<String, Serializable> var2, Object var3) throws Exception;

    protected ObjectEntry partialUpdateObjectEntry(long userId, ObjectEntry objectEntry, Map<String, Serializable> values) throws PortalException {
        return this.objectEntryLocalService.partialUpdateObjectEntry(userId, objectEntry.getObjectEntryId(), objectEntry.getObjectEntryFolderId(), values, new ServiceContext());
    }

    private long _getObjectDefinitionId(long companyId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_CMS_BULK_ACTION_TASK_ITEM", companyId);
        return objectDefinition.getObjectDefinitionId();
    }
}

