/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.system.info.collection.provider;

import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.object.info.collection.provider.util.ObjectEntryInfoCollectionProviderUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectEntry;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SystemObjectEntrySingleFormVariationInfoCollectionProvider
implements SingleFormVariationInfoCollectionProvider<SystemObjectEntry> {
    private final String _itemClassName;
    private final ObjectDefinition _objectDefinition;
    private final SystemObjectDefinitionManager _systemObjectDefinitionManager;

    public SystemObjectEntrySingleFormVariationInfoCollectionProvider(String itemClassName, ObjectDefinition objectDefinition, SystemObjectDefinitionManager systemObjectDefinitionManager) {
        this._itemClassName = itemClassName;
        this._objectDefinition = objectDefinition;
        this._systemObjectDefinitionManager = systemObjectDefinitionManager;
    }

    public InfoPage<SystemObjectEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        try {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
            if (themeDisplay == null) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            Page page = this._systemObjectDefinitionManager.getPage(themeDisplay.getUser(), ObjectEntryInfoCollectionProviderUtil.getSearch((CollectionQuery)collectionQuery), null, ObjectEntryInfoCollectionProviderUtil.getPagination((Pagination)collectionQuery.getPagination()), null);
            if (page == null) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            return InfoPage.of((List)TransformUtil.transform((Collection)page.getItems(), pageItem -> {
                Map values = (Map)ObjectMapperUtil.readValue(Map.class, (String)pageItem.toString());
                if (values == null) {
                    return null;
                }
                return new SystemObjectEntry(GetterUtil.getLong(values.get("id")), GetterUtil.getString(values.get("externalReferenceCode")), values);
            }), (Pagination)collectionQuery.getPagination(), (int)((int)page.getTotalCount()));
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get collection info page for object definition " + this._objectDefinition.getObjectDefinitionId(), exception);
        }
    }

    public String getCollectionItemClassName() {
        return this._itemClassName;
    }

    public String getFormVariationKey() {
        return String.valueOf(this._objectDefinition.getObjectDefinitionId());
    }

    public String getKey() {
        return StringBundler.concat((Object[])new Object[]{SystemObjectEntrySingleFormVariationInfoCollectionProvider.class.getName(), "_", this._objectDefinition.getCompanyId(), "_", this._objectDefinition.getName()});
    }

    public String getLabel(Locale locale) {
        return this._objectDefinition.getPluralLabel(locale);
    }

    public boolean isAvailable() {
        return this._objectDefinition.getCompanyId() == CompanyThreadLocal.getCompanyId().longValue();
    }
}

