/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Objects;

public class ObjectEntryMtoMObjectRelatedModelsProviderImpl
implements ObjectRelatedModelsProvider<ObjectEntry> {
    private final String _className;
    private final long _companyId;
    private final ObjectEntryService _objectEntryService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;

    public ObjectEntryMtoMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectEntryService objectEntryService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this._objectEntryService = objectEntryService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._className = objectDefinition.getClassName();
        this._companyId = objectDefinition.getCompanyId();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey, String deletionType) throws PortalException {
        List<ObjectEntry> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, null, false, primaryKey, null, -1, -1, null);
        if (relatedModels.isEmpty()) {
            return;
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (Objects.equals(deletionType, "prevent") && !objectRelationship.isReverse()) {
            throw new RequiredObjectRelationshipException(objectRelationship);
        }
        this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey);
        if (Objects.equals(deletionType, "cascade") && !objectRelationship.isReverse()) {
            for (ObjectEntry objectEntry : relatedModels) {
                this._objectEntryService.deleteObjectEntry(objectEntry.getObjectEntryId());
            }
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey1, primaryKey2);
    }

    public String getClassName() {
        return this._className;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getObjectRelationshipType() {
        return "manyToMany";
    }

    public List<ObjectEntry> getRelatedModels(long groupId, long objectRelationshipId, Predicate predicate, boolean preferApproved, long primaryKey, String search, int start, int end, Sort[] sorts) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        return this._objectEntryService.getManyToManyObjectEntries(groupId, objectRelationship.getObjectRelationshipId(), primaryKey, true, objectRelationship.isReverse(), search, start, end);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, Predicate predicate, long primaryKey, String search) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        return this._objectEntryService.getManyToManyObjectEntriesCount(groupId, objectRelationship.getObjectRelationshipId(), primaryKey, true, objectRelationship.isReverse(), search);
    }

    public List<ObjectEntry> getUnrelatedModels(long companyId, long groupId, ObjectDefinition objectDefinition, long objectEntryId, long objectRelationshipId, String search, int start, int end) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        return this._objectEntryService.getManyToManyObjectEntries(groupId, objectRelationship.getObjectRelationshipId(), objectEntryId, false, objectRelationship.isReverse(), search, start, end);
    }

    public int getUnrelatedModelsCount(long companyId, long groupId, ObjectDefinition objectDefinition, long objectEntryId, long objectRelationshipId, String search) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        return this._objectEntryService.getManyToManyObjectEntriesCount(groupId, objectRelationship.getObjectRelationshipId(), objectEntryId, false, objectRelationship.isReverse(), search);
    }

    public void moveRelatedModelToTrash(long userId, long groupId, long objectRelationshipId, long primaryKey, String deletionType) throws PortalException {
        List<ObjectEntry> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, null, false, primaryKey, null, -1, -1, null);
        if (relatedModels.isEmpty()) {
            return;
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (Objects.equals(deletionType, "prevent") && !objectRelationship.isReverse()) {
            throw new RequiredObjectRelationshipException(objectRelationship);
        }
        if (Objects.equals(deletionType, "cascade") && !objectRelationship.isReverse()) {
            for (ObjectEntry objectEntry : relatedModels) {
                this._objectEntryService.moveObjectEntryToTrash(objectEntry, new ServiceContext());
            }
        }
    }

    public void restoreRelatedModelsFromTrash(long userId, long groupId, long objectRelationshipId, long primaryKey, String deletionType) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (!Objects.equals(deletionType, "cascade") || objectRelationship.isReverse()) {
            return;
        }
        for (ObjectEntry objectEntry : this.getRelatedModels(groupId, objectRelationshipId, null, false, primaryKey, null, -1, -1, null)) {
            if (!objectEntry.isInTrash()) continue;
            this._objectEntryService.restoreObjectEntryFromTrash(objectEntry, new ServiceContext());
        }
    }
}

