/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.definition.util.ObjectDefinitionThreadLocal;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectFieldModelListener
extends BaseModelListener<ObjectField> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private Language _language;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;

    public void onAfterCreate(ObjectField objectField) throws ModelListenerException {
        this._addAssignToMeObjectAction(objectField);
    }

    public void onAfterRemove(ObjectField objectField) throws ModelListenerException {
        this._deleteAssignToMeObjectAction(objectField);
    }

    public void onAfterUpdate(ObjectField originalObjectField, ObjectField objectField) throws ModelListenerException {
        if (originalObjectField.compareBusinessType(objectField.getBusinessType())) {
            return;
        }
        this._addAssignToMeObjectAction(objectField);
        this._deleteAssignToMeObjectAction(originalObjectField);
    }

    public void onBeforeCreate(ObjectField objectField) throws ModelListenerException {
        this._route("ADD", objectField);
    }

    public void onBeforeRemove(ObjectField objectField) throws ModelListenerException {
        this._route("DELETE", objectField);
    }

    public void onBeforeUpdate(ObjectField originalObjectField, ObjectField objectField) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectField.class.getName(), (long)objectField.getObjectFieldId(), this._getModifiedAttributes(originalObjectField, objectField)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private void _addAssignToMeObjectAction(ObjectField objectField) throws ModelListenerException {
        if (!objectField.compareBusinessType("Assignee")) {
            return;
        }
        try (SafeCloseable safeCloseable = ObjectDefinitionThreadLocal.setSkipBundleAllowedCheckWithSafeCloseable((boolean)true);){
            this._objectActionLocalService.addObjectAction(null, objectField.getUserId(), objectField.getObjectDefinitionId(), true, null, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "there-was-an-unknown-error")), LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "assign-to-me")), "assignToMe", "update-object-entry", "standalone", UnicodePropertiesBuilder.create((boolean)true).put("objectDefinitionId", objectField.getObjectDefinitionId()).put("predefinedValues", JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"name", (Object)objectField.getName()).put("value", JSONUtil.put((String)"externalReferenceCode", (Object)"currentUserExternalReferenceCode").put("type", "User").toString())}).toString()).build(), true);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private void _deleteAssignToMeObjectAction(ObjectField objectField) throws ModelListenerException {
        if (!objectField.compareBusinessType("Assignee")) {
            return;
        }
        try (SafeCloseable safeCloseable = ObjectDefinitionThreadLocal.setSkipBundleAllowedCheckWithSafeCloseable((boolean)true);){
            ObjectAction objectAction = this._objectActionLocalService.fetchObjectAction(objectField.getObjectDefinitionId(), "assignToMe");
            if (objectAction != null) {
                this._objectActionLocalService.deleteObjectAction(objectAction);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectField originalObjectField, ObjectField objectField) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectField, (Object)originalObjectField);
        attributesBuilder.add("businessType");
        attributesBuilder.add("DBColumnName");
        attributesBuilder.add("DBType");
        attributesBuilder.add("indexed");
        attributesBuilder.add("indexedAsKeyword");
        attributesBuilder.add("indexedLanguageId");
        attributesBuilder.add("labelMap");
        attributesBuilder.add("listTypeDefinitionId");
        attributesBuilder.add("name");
        attributesBuilder.add("required");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectField objectField) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectField.class.getName(), (long)objectField.getObjectFieldId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("businessType", objectField.getBusinessType()).put("DBColumnName", objectField.getDBColumnName()).put("DBType", objectField.getDBType()).put("indexed", objectField.isIndexed()).put("indexedAsKeyword", objectField.isIndexedAsKeyword()).put("indexedLanguageId", objectField.getIndexedLanguageId()).put("labelMap", (Object)objectField.getLabelMap()).put("listTypeDefinitionId", objectField.getListTypeDefinitionId()).put("name", objectField.getName()).put("required", objectField.isRequired());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

