/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryVersionLocalService;
import com.liferay.object.util.comparator.ObjectEntryVersionVersionComparator;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectEntryVersionModelListener
extends BaseModelListener<ObjectEntryVersion> {
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryVersionLocalService _objectEntryVersionLocalService;

    public void onAfterCreate(ObjectEntryVersion objectEntryVersion) throws ModelListenerException {
        try {
            this._addOrUpdateLatestApprovedObjectEntry(objectEntryVersion);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterRemove(ObjectEntryVersion objectEntryVersion) throws ModelListenerException {
        try {
            this._onAfterRemove(objectEntryVersion);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterUpdate(ObjectEntryVersion originalObjectEntryVersion, ObjectEntryVersion objectEntryVersion) throws ModelListenerException {
        if (objectEntryVersion.getStatus() == 8) {
            return;
        }
        try {
            this._addOrUpdateLatestApprovedObjectEntry(objectEntryVersion);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _addOrUpdateLatestApprovedObjectEntry(ObjectEntryVersion objectEntryVersion) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((long)objectEntryVersion.getCompanyId(), (String)"LPD-17564")) {
            return;
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(objectEntryVersion.getObjectEntryId());
        if (objectEntry == null || objectEntry.isApproved()) {
            this._deleteLatestApprovedObjectEntry(objectEntryVersion.getObjectEntryId());
            return;
        }
        ObjectEntryVersion latestApprovedObjectEntryVersion = this._objectEntryVersionLocalService.fetchLatestApprovedObjectEntryVersion(objectEntry.getObjectEntryId(), (OrderByComparator)ObjectEntryVersionVersionComparator.getInstance((boolean)false));
        if (latestApprovedObjectEntryVersion == null) {
            this._deleteLatestApprovedObjectEntry(objectEntryVersion.getObjectEntryId());
            return;
        }
        ObjectEntry latestApprovedObjectEntry = this._objectEntryLocalService.fetchObjectEntryByHeadObjectEntryId(objectEntryVersion.getObjectEntryId());
        if (latestApprovedObjectEntry != null) {
            if (latestApprovedObjectEntry.getVersion() == latestApprovedObjectEntryVersion.getVersion()) {
                return;
            }
            this._objectEntryLocalService.deleteObjectEntry(latestApprovedObjectEntry);
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntryVersion.getObjectDefinitionId());
        com.liferay.object.rest.dto.v1_0.ObjectEntry contentObjectEntry = com.liferay.object.rest.dto.v1_0.ObjectEntry.unsafeToDTO((String)latestApprovedObjectEntryVersion.getContent());
        Map properties = contentObjectEntry.getProperties();
        this._objectEntryLocalService.addLatestApprovedObjectEntry(null, objectEntry.getGroupId(), objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectDefinition, objectEntry.getObjectEntryFolderId(), objectEntry.getDefaultLanguageId(), latestApprovedObjectEntryVersion.getVersion(), (Map)properties.get("properties"));
    }

    private void _deleteLatestApprovedObjectEntry(long headObjectEntryId) throws PortalException {
        ObjectEntry latestApprovedObjectEntry = this._objectEntryLocalService.fetchObjectEntryByHeadObjectEntryId(headObjectEntryId);
        if (latestApprovedObjectEntry == null) {
            return;
        }
        this._objectEntryLocalService.deleteObjectEntry(latestApprovedObjectEntry);
    }

    private void _onAfterRemove(ObjectEntryVersion objectEntryVersion) throws PortalException {
        this._addOrUpdateLatestApprovedObjectEntry(objectEntryVersion);
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntryVersion.getObjectDefinitionId());
        if (!objectDefinition.isEnableObjectEntryHistory()) {
            return;
        }
        AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"DELETE", (ClassedModel)objectEntryVersion, null);
        JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
        JSONObject contentJSONObject = this._jsonFactory.createJSONObject(objectEntryVersion.getContent());
        JSONObject propertiesJSONObject = contentJSONObject.getJSONObject("properties");
        for (String key : propertiesJSONObject.keySet()) {
            additionalInfoJSONObject.put(key, propertiesJSONObject.get(key));
        }
        this._auditRouter.route(auditMessage);
    }
}

