/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=default.permission.object"}, service={BulkSelectionAction.class})
public class DefaultPermissionObjectBulkSelectionAction
implements BulkSelectionAction<Object> {
    private static final Log _log = LogFactoryUtil.getLog(DefaultPermissionObjectBulkSelectionAction.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(User user, BulkSelection<Object> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        long bulkActionTaskId = GetterUtil.getLong((Object)inputMap.get("bulkActionTaskId"));
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(bulkActionTaskId);
        Map values = objectEntry.getValues();
        values.put("numberOfItems", bulkSelection.getSize());
        String executionStatus = "completed";
        AtomicInteger numberOfFailedItems = new AtomicInteger(0);
        AtomicInteger numberOfSuccessfulItems = new AtomicInteger(0);
        try {
            values.put("executionStatus", "started");
            objectEntry = this._partialUpdateObjectEntry(objectEntry, values);
            values = objectEntry.getValues();
            long companyId = objectEntry.getCompanyId();
            bulkSelection.forEach(object -> {
                long objectDefinitionId = this._getObjectDefinitionId(companyId);
                String status = "completed";
                try {
                    ObjectEntry objectObjectEntry = (ObjectEntry)object;
                    Map objectObjectEntryValues = objectObjectEntry.getValues();
                    String roleKey = (String)inputMap.get("roleKey");
                    if (Validator.isBlank((String)roleKey)) {
                        objectObjectEntryValues.put("defaultPermissions", MapUtil.getString((Map)inputMap, (Object)"defaultPermissions"));
                    } else {
                        JSONObject existingJSONObject = this._jsonFactory.createJSONObject(GetterUtil.getString(objectObjectEntryValues.get("defaultPermissions"), (String)"{}"));
                        JSONObject newJSONObject = this._jsonFactory.createJSONObject(GetterUtil.getString((String)MapUtil.getString((Map)inputMap, (Object)"defaultPermissions"), (String)"{}"));
                        existingJSONObject.put("L_CONTENTS", this._getJSONObject(existingJSONObject.getJSONObject("L_CONTENTS"), newJSONObject.getJSONObject("L_CONTENTS"), roleKey)).put("L_FILES", this._getJSONObject(existingJSONObject.getJSONObject("L_FILES"), newJSONObject.getJSONObject("L_FILES"), roleKey)).put("OBJECT_ENTRY_FOLDERS", this._getJSONObject(existingJSONObject.getJSONObject("OBJECT_ENTRY_FOLDERS"), newJSONObject.getJSONObject("OBJECT_ENTRY_FOLDERS"), roleKey));
                        objectObjectEntryValues.put("defaultPermissions", existingJSONObject.toString());
                    }
                    this._partialUpdateObjectEntry(objectObjectEntry, objectObjectEntryValues);
                    numberOfSuccessfulItems.getAndIncrement();
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)portalException);
                    }
                    numberOfFailedItems.getAndIncrement();
                    status = "failed";
                }
                finally {
                    this._objectEntryLocalService.addObjectEntry(0L, user.getUserId(), objectDefinitionId, 0L, null, (Map)HashMapBuilder.put((Object)"bulkActionTaskId", (Object)bulkActionTaskId).put((Object)"executionStatus", (Object)status).put((Object)"r_cmsBATaskToCMSBATaskItems_c_cmsBulkActionTaskId", (Object)bulkActionTaskId).put((Object)"type", (Object)"ObjectEntryFolder").build(), new ServiceContext());
                }
            });
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            executionStatus = "failed";
        }
        finally {
            values.put("completionDate", new Date());
            values.put("executionStatus", executionStatus);
            values.put("numberOfFailedItems", numberOfFailedItems.get());
            values.put("numberOfSuccessfulItems", numberOfSuccessfulItems.get());
            this._partialUpdateObjectEntry(objectEntry, values);
        }
    }

    private JSONObject _getJSONObject(JSONObject jsonObject1, JSONObject jsonObject2, String key) {
        if (jsonObject1 == null) {
            jsonObject1 = this._jsonFactory.createJSONObject();
        }
        if (jsonObject2 == null || jsonObject2.get(key) == null) {
            return jsonObject1;
        }
        jsonObject1.put(key, jsonObject2.get(key));
        return jsonObject1;
    }

    private long _getObjectDefinitionId(long companyId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_CMS_BULK_ACTION_TASK_ITEM", companyId);
        return objectDefinition.getObjectDefinitionId();
    }

    private ObjectEntry _partialUpdateObjectEntry(ObjectEntry objectEntry, Map<String, Serializable> values) throws PortalException {
        return this._objectEntryLocalService.partialUpdateObjectEntry(objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectEntry.getObjectEntryFolderId(), values, new ServiceContext());
    }
}

