/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFieldSettingTable;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.ReindexCacheThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.object.model.ObjectField"}, service={ModelDocumentContributor.class})
public class ObjectFieldModelDocumentContributor
implements ModelDocumentContributor<ObjectField> {
    @Reference
    private Localization _localization;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

    public void contribute(Document document, ObjectField objectField) {
        document.addText("name", objectField.getName());
        document.addLocalizedText("label", this._localization.populateLocalizationMap(objectField.getLabelMap(), objectField.getDefaultLanguageId(), 0L));
        document.addLocalizedKeyword("localized_label", objectField.getLabelMap(), true, true);
        document.addKeyword("objectDefinitionId", objectField.getObjectDefinitionId());
        document.addKeyword("objectFieldId", objectField.getObjectFieldId());
        document.addKeyword("state", objectField.isState());
        if (objectField.hasUniqueValues()) {
            document.addKeyword("unique", this._isUnique(objectField.getObjectFieldId()));
        }
        document.remove("userName");
    }

    private boolean _isUnique(long objectFieldId) {
        Set uniqueObjectFieldIds = (Set)ReindexCacheThreadLocal.getGlobalReindexCache(() -> -1, (String)ObjectFieldModelDocumentContributor.class.getName(), count -> new HashSet((Collection)this._objectFieldSettingLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{ObjectFieldSettingTable.INSTANCE.objectFieldId}).from((Table)ObjectFieldSettingTable.INSTANCE).where(ObjectFieldSettingTable.INSTANCE.name.eq((Object)"uniqueValues").and((Expression)DSLFunctionFactoryUtil.lower((Expression)DSLFunctionFactoryUtil.castClobText((Expression)ObjectFieldSettingTable.INSTANCE.value)).eq((Object)"true"))))));
        if (uniqueObjectFieldIds == null) {
            ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectFieldId, "uniqueValues");
            if (objectFieldSetting == null) {
                return false;
            }
            return GetterUtil.getBoolean((String)objectFieldSetting.getValue());
        }
        return uniqueObjectFieldIds.contains(objectFieldId);
    }
}

