/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.dynamic.data.mapping.util.NumberUtil;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Decimal"}, service={ObjectFieldBusinessType.class})
public class DecimalObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"defaultValue", "defaultValueType"});
    }

    public String getDBType() {
        return "Double";
    }

    public String getDDMFormFieldTypeName() {
        return "numeric";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-a-decimal-number-that-supports-fractional-portions");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "decimal");
    }

    public String getName() {
        return "Decimal";
    }

    @Override
    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return HashMapBuilder.put((Object)"dataType", (Object)"double").putAll(super.getProperties(objectField, objectFieldRenderingContext)).build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.DOUBLE;
    }

    public void validateObjectFieldSettingsDefaultValue(ObjectField objectField, Map<String, String> objectFieldSettingsValuesMap) throws PortalException {
        if (objectFieldSettingsValuesMap.isEmpty()) {
            return;
        }
        super.validateObjectFieldSettingsDefaultValue(objectField, objectFieldSettingsValuesMap);
        if (Objects.equals(objectFieldSettingsValuesMap.get("defaultValueType"), "expressionBuilder")) {
            return;
        }
        String defaultValue = objectFieldSettingsValuesMap.get("defaultValue");
        if (Validator.isNull((String)defaultValue)) {
            return;
        }
        if (defaultValue.startsWith("-")) {
            defaultValue = defaultValue.substring(1);
        }
        if (NumberUtil.hasDecimalSeparator((String)defaultValue)) {
            defaultValue = StringUtil.removeChar((String)defaultValue, (char)defaultValue.charAt(NumberUtil.getDecimalSeparatorIndex((String)defaultValue)));
        }
        this.validateMaxLength(16, "defaultValue", defaultValue);
    }
}

