/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=edit.object.categories"}, service={BulkSelectionAction.class})
public class EditObjectCategoriesBulkSelectionAction
implements BulkSelectionAction<Object> {
    private static final Log _log = LogFactoryUtil.getLog(EditObjectCategoriesBulkSelectionAction.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(User user, BulkSelection<Object> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        long bulkActionTaskId = GetterUtil.getLong((Object)inputMap.get("bulkActionTaskId"));
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(bulkActionTaskId);
        Map values = objectEntry.getValues();
        values.put("numberOfItems", bulkSelection.getSize());
        String executionStatus = "completed";
        AtomicInteger numberOfFailedItems = new AtomicInteger(0);
        AtomicInteger numberOfSuccessfulItems = new AtomicInteger(0);
        try {
            values.put("executionStatus", "started");
            long companyId = objectEntry.getCompanyId();
            bulkSelection.forEach(object -> {
                long objectDefinitionId = this._getObjectDefinitionId(companyId);
                String status = "completed";
                try {
                    if (object instanceof ObjectEntry) {
                        this._updateAssetEntry(user, inputMap, (ObjectEntry)object);
                        numberOfSuccessfulItems.getAndIncrement();
                    }
                }
                catch (PortalException portalException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)portalException);
                    }
                    numberOfFailedItems.getAndIncrement();
                    status = "failed";
                }
                finally {
                    this._objectEntryLocalService.addObjectEntry(0L, user.getUserId(), objectDefinitionId, 0L, null, (Map)HashMapBuilder.put((Object)"bulkActionTaskId", (Object)bulkActionTaskId).put((Object)"executionStatus", (Object)status).put((Object)"r_cmsBATaskToCMSBATaskItems_c_cmsBulkActionTaskId", (Object)bulkActionTaskId).put((Object)"type", (Object)"ObjectEntryFolder").build(), new ServiceContext());
                }
            });
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            executionStatus = "failed";
        }
        finally {
            values.put("completionDate", new Date());
            values.put("executionStatus", executionStatus);
            values.put("numberOfFailedItems", numberOfFailedItems.get());
            values.put("numberOfSuccessfulItems", numberOfSuccessfulItems.get());
            this._partialUpdateObjectEntry(objectEntry, values);
        }
    }

    private long _getObjectDefinitionId(long companyId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_CMS_BULK_ACTION_TASK_ITEM", companyId);
        return objectDefinition.getObjectDefinitionId();
    }

    private ObjectEntry _partialUpdateObjectEntry(ObjectEntry objectEntry, Map<String, Serializable> values) throws PortalException {
        return this._objectEntryLocalService.partialUpdateObjectEntry(objectEntry.getUserId(), objectEntry.getObjectEntryId(), objectEntry.getObjectEntryFolderId(), values, new ServiceContext());
    }

    private Set<Long> _toLongSet(Map<String, Serializable> map, String key) {
        try {
            Serializable values = map.get(key);
            if (values instanceof Long[]) {
                return SetUtil.fromArray((Object[])((Long[])values));
            }
            HashSet<Long> set = new HashSet<Long>();
            for (Integer value : (Integer[])values) {
                set.add(value.longValue());
            }
            return set;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return SetUtil.fromArray((Object[])new Long[0]);
        }
    }

    private void _updateAssetEntry(User user, Map<String, Serializable> inputMap, ObjectEntry objectEntry) throws PortalException {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(objectEntry.getModelClassName(), objectEntry.getObjectEntryId());
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        if (assetEntry == null || !ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE").booleanValue()) {
            return;
        }
        long[] newCategoryIds = new long[]{};
        Set<Long> toAddCategoryIds = this._toLongSet(inputMap, "toAddCategoryIds");
        if (SetUtil.isNotEmpty(toAddCategoryIds)) {
            newCategoryIds = ArrayUtil.toLongArray(toAddCategoryIds);
        }
        if (MapUtil.getBoolean(inputMap, (String)"append")) {
            Set currentCategoryIds = SetUtil.fromArray((long[])assetEntry.getCategoryIds());
            Set<Long> toRemoveCategoryIds = this._toLongSet(inputMap, "toRemoveCategoryIds");
            currentCategoryIds.removeAll(toRemoveCategoryIds);
            currentCategoryIds.addAll(toAddCategoryIds);
            newCategoryIds = ArrayUtil.toLongArray((Collection)currentCategoryIds);
        }
        this._assetEntryLocalService.updateEntry(assetEntry.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK(), newCategoryIds, assetEntry.getTagNames());
    }
}

