/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v9_2_1;

import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationTemplateLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;

public class ObjectActionUpgradeProcess
extends UpgradeProcess {
    private final NotificationTemplateLocalService _notificationTemplateLocalService;

    public ObjectActionUpgradeProcess(NotificationTemplateLocalService notificationTemplateLocalService) {
        this._notificationTemplateLocalService = notificationTemplateLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select objectActionId, parameters from ObjectAction ", "where objectActionExecutorKey = '", "notification", "' and objectActionTriggerKey in ('", "onAfterAdd", "', '", "onAfterUpdate", "')"})));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update ObjectAction set parameters = ? where objectActionId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.create((boolean)true).load(resultSet.getString("parameters")).put("usePreferredLanguageForGuests", "false").build();
                NotificationTemplate notificationTemplate = this._notificationTemplateLocalService.fetchNotificationTemplate(GetterUtil.getLong((String)((String)unicodeProperties.get((Object)"notificationTemplateId"))));
                if (notificationTemplate == null || !Objects.equals(notificationTemplate.getType(), "email")) continue;
                preparedStatement2.setString(1, unicodeProperties.toString());
                preparedStatement2.setLong(2, resultSet.getLong("objectActionId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

