/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectFolder;
import com.liferay.object.service.ObjectFolderLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectFolder service. Represents a row in the &quot;ObjectFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFolderImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFolderImpl
 * @see ObjectFolder
 * @generated
 */
public abstract class ObjectFolderBaseImpl
	extends ObjectFolderModelImpl implements ObjectFolder {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object folder model instance should use the <code>ObjectFolder</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectFolderLocalServiceUtil.addObjectFolder(this);
		}
		else {
			ObjectFolderLocalServiceUtil.updateObjectFolder(this);
		}
	}

}