/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.object.entry.util.ObjectEntryValuesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.ml.embedding.text.TextEmbeddingDocumentContributor;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class ObjectEntryModelDocumentContributor
implements ModelDocumentContributor<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelDocumentContributor.class);
    private static final Format _format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final String _className;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectFolderLocalService _objectFolderLocalService;
    private final TextEmbeddingDocumentContributor _textEmbeddingDocumentContributor;

    public ObjectEntryModelDocumentContributor(AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, String className, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryFolderLocalService objectEntryFolderLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectFolderLocalService objectFolderLocalService, TextEmbeddingDocumentContributor textEmbeddingDocumentContributor) {
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._className = className;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryFolderLocalService = objectEntryFolderLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectFolderLocalService = objectFolderLocalService;
        this._textEmbeddingDocumentContributor = textEmbeddingDocumentContributor;
    }

    public void contribute(Document document, ObjectEntry objectEntry) {
        block2: {
            try {
                this._contribute(document, objectEntry);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to index object entry " + objectEntry.getObjectEntryId()), (Throwable)exception);
            }
        }
    }

    private void _addField(FieldArray fieldArray, String fieldName, String valueFieldName, String value) {
        Field field = new Field("");
        field.addField(new Field("fieldName", fieldName));
        field.addField(new Field("valueFieldName", valueFieldName));
        field.addField(new Field(valueFieldName, value));
        fieldArray.addField(field);
    }

    private void _appendToContent(ObjectContentHelper objectContentHelper, String locale, String objectFieldName, String valueString) {
        StringBundler sb = new StringBundler(4);
        sb.append(objectFieldName);
        sb.append(": ");
        sb.append(valueString);
        sb.append(", ");
        if (locale != null) {
            objectContentHelper.contributeToLocale(locale, sb);
        } else {
            objectContentHelper.contributeToAll(sb);
        }
    }

    private void _contribute(Document document, FieldArray fieldArray, String fieldName, Object fieldValue, String locale, ObjectContentHelper objectContentHelper, ObjectDefinition objectDefinition, ObjectEntry objectEntry, ObjectField objectField, Map<String, Serializable> values) {
        if (!objectField.isIndexed()) {
            return;
        }
        if (fieldValue == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Object entry ", objectEntry.getObjectEntryId(), " has object field \"", objectField.getName(), "\" with a null value"}));
            }
            return;
        }
        if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Attachment") || StringUtil.equals((String)objectField.getBusinessType(), (String)"RichText")) {
            fieldValue = ObjectEntryValuesUtil.getValueString((ObjectField)objectField, values);
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"MultiselectPicklist") && fieldValue instanceof List) {
            fieldValue = ListUtil.toString((List)((List)fieldValue), (String)null, (String)", ");
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Picklist") && fieldValue instanceof ListEntry) {
            ListEntry listEntry = (ListEntry)fieldValue;
            fieldValue = listEntry.getKey();
        } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"PrecisionDecimal")) {
            fieldValue = BigDecimalUtil.stripTrailingZeros((BigDecimal)((BigDecimal)fieldValue));
        } else if (Objects.equals(objectDefinition.getAccountEntryRestrictedObjectFieldId(), objectField.getObjectFieldId())) {
            Long accountEntryId = (Long)fieldValue;
            document.addKeyword("accountEntryRestrictedObjectFieldValue", accountEntryId);
            document.addKeyword("accountEntryRestrictedOrganizationIds", (Long[])TransformUtil.transformToArray((Collection)this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId.longValue()), AccountEntryOrganizationRelModel::getOrganizationId, Long.class));
        }
        String valueString = String.valueOf(fieldValue);
        if (objectField.isIndexedAsKeyword()) {
            this._addField(fieldArray, fieldName, "value_keyword", StringUtil.lowerCase((String)valueString));
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof BigDecimal) {
            this._addField(fieldArray, fieldName, "value_double", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Boolean) {
            this._addField(fieldArray, fieldName, "value_boolean", valueString);
            this._addField(fieldArray, fieldName, "value_keyword", this._translate((Boolean)fieldValue));
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Date) {
            this._addField(fieldArray, fieldName, "value_date", this._getDateString(fieldValue));
            this._appendToContent(objectContentHelper, locale, fieldName, this._getDateString(fieldValue));
        } else if (fieldValue instanceof Double) {
            this._addField(fieldArray, fieldName, "value_double", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Integer) {
            this._addField(fieldArray, fieldName, "value_integer", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof Long) {
            this._addField(fieldArray, fieldName, "value_long", valueString);
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof String) {
            if (Validator.isBlank((String)objectField.getIndexedLanguageId())) {
                this._addField(fieldArray, fieldName, "value_text", valueString);
            } else if (objectField.isLocalized()) {
                this._addField(fieldArray, fieldName, "value_" + locale, valueString);
            } else {
                this._addField(fieldArray, fieldName, "value_" + objectField.getIndexedLanguageId(), valueString);
            }
            this._addField(fieldArray, fieldName, "value_keyword_lowercase", this._getSortableValue(valueString));
            this._appendToContent(objectContentHelper, locale, fieldName, valueString);
        } else if (fieldValue instanceof byte[]) {
            this._addField(fieldArray, fieldName, "value_binary", Base64.encode((byte[])((byte[])fieldValue)));
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Object entry ", objectEntry.getObjectEntryId(), " has object field \"", fieldName, "\" with unsupported value ", fieldValue}));
        }
    }

    private void _contribute(Document document, ObjectEntry objectEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + String.valueOf(document)));
            _log.debug((Object)("Object entry " + String.valueOf(objectEntry)));
        }
        document.add(new Field(Field.getSortableFieldName((String)"entryClassPK"), document.get("entryClassPK")));
        FieldArray fieldArray = (FieldArray)document.getField("nestedFieldArray");
        if (fieldArray == null) {
            fieldArray = new FieldArray("nestedFieldArray");
            document.add((Field)fieldArray);
        }
        document.addKeyword("objectDefinitionId", objectEntry.getObjectDefinitionId());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectEntry.getObjectDefinitionId());
        document.addKeyword("objectDefinitionName", objectDefinition.getShortName());
        Map values = objectEntry.getValues();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectEntry.getObjectDefinitionId(), false);
        ObjectContentHelper objectContentHelper = new ObjectContentHelper(objectDefinition.isEnableLocalization(), objectEntry, objectFields, this._textEmbeddingDocumentContributor);
        for (ObjectField objectField : objectFields) {
            if (objectField.isLocalized()) {
                Map localizedValues = (Map)values.get(objectField.getI18nObjectFieldName());
                if (MapUtil.isEmpty((Map)localizedValues)) continue;
                for (Map.Entry localeMap : localizedValues.entrySet()) {
                    this._contribute(document, fieldArray, objectField.getName(), localizedValues.get(localeMap.getKey()), LocaleUtil.fromLanguageId((String)((String)localeMap.getKey()), (boolean)true, (boolean)false).toString(), objectContentHelper, objectDefinition, objectEntry, objectField, values);
                }
                continue;
            }
            this._contribute(document, fieldArray, objectField.getName(), values.get(objectField.getName()), null, objectContentHelper, objectDefinition, objectEntry, objectField, values);
        }
        objectContentHelper.trim();
        document.add(new Field("objectEntryContent", objectContentHelper.getContent()));
        objectContentHelper.getLocalizedContentMap();
        document.addKeyword("objectEntryId", objectEntry.getObjectEntryId());
        document.add(new Field("objectEntryTitle", objectEntry.getTitleValue()));
        ObjectFolder objectFolder = this._objectFolderLocalService.getObjectFolder(objectDefinition.getObjectFolderId());
        document.addKeyword("objectFolderExternalReferenceCode", objectFolder.getExternalReferenceCode(), true);
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPD-17564")) {
            this._contributeObjectEntryFolder(document, objectEntry.getObjectEntryFolderId());
            long fileEntryId = GetterUtil.getLong(values.get("file"));
            if (fileEntryId != 0L) {
                this._contributeFile(document, fileEntryId);
            }
        }
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPS-122920")) {
            this._contributeTextEmbeddings(document, objectContentHelper, objectDefinition, objectEntry);
        }
    }

    private void _contributeFile(Document document, long fileEntryId) {
        DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.fetchDLFileEntry((long)fileEntryId);
        if (fileEntry != null) {
            document.addKeyword("extension", fileEntry.getExtension());
        }
    }

    private void _contributeObjectEntryFolder(Document document, long objectEntryFolderId) {
        document.addKeyword("folderId", objectEntryFolderId);
        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.fetchObjectEntryFolder(objectEntryFolderId);
        if (objectEntryFolder == null) {
            return;
        }
        ObjectEntryFolder rootObjectEntryFolder = this._getRootObjectEntryFolder(objectEntryFolder);
        if (rootObjectEntryFolder == null) {
            return;
        }
        String cmsSection = this._getCMSSection(rootObjectEntryFolder.getExternalReferenceCode());
        if (cmsSection == null) {
            return;
        }
        document.addKeyword("cms_kind", "object");
        document.addKeyword("cms_root", rootObjectEntryFolder.getObjectEntryFolderId() == objectEntryFolderId);
        document.addKeyword("cms_section", cmsSection);
    }

    private void _contributeTextEmbeddings(Document document, ObjectContentHelper objectContentHelper, ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        if (!objectDefinition.isEnableLocalization()) {
            this._textEmbeddingDocumentContributor.contribute(document, (BaseModel)objectEntry, objectContentHelper.getContent());
            return;
        }
        Map<String, String> localizedContentMap = objectContentHelper.getLocalizedContentMap();
        for (Map.Entry<String, String> localizedContent : localizedContentMap.entrySet()) {
            this._textEmbeddingDocumentContributor.contribute(document, localizedContent.getKey(), (BaseModel)objectEntry, localizedContent.getValue());
        }
    }

    private String _getCMSSection(String externalReferenceCode) {
        if (externalReferenceCode.equals("L_CONTENTS")) {
            return "contents";
        }
        if (externalReferenceCode.equals("L_FILES")) {
            return "files";
        }
        return null;
    }

    private String _getDateString(Object value) {
        return _format.format(value);
    }

    private ObjectEntryFolder _getRootObjectEntryFolder(ObjectEntryFolder objectEntryFolder) {
        if (objectEntryFolder == null) {
            return null;
        }
        if (Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_CONTENTS") || Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_FILES")) {
            return objectEntryFolder;
        }
        String[] parts = StringUtil.split((String)objectEntryFolder.getTreePath(), (char)'/');
        if (parts.length <= 2) {
            return null;
        }
        return this._objectEntryFolderLocalService.fetchObjectEntryFolder(GetterUtil.getLong((String)parts[1]));
    }

    private String _getSortableValue(String value) {
        if (value.length() > 256) {
            return value.substring(0, 256);
        }
        return value;
    }

    private String _translate(Boolean value) {
        if (value.booleanValue()) {
            return "yes";
        }
        return "no";
    }

    private static class ObjectContentHelper {
        private final StringBundler _contentSB;
        private final Map<String, StringBundler> _localizedContentSBMap = new TreeMap<String, StringBundler>();

        public void contributeToAll(StringBundler sb) {
            this._contentSB.append(sb);
            for (StringBundler localizedContentSB : this._localizedContentSBMap.values()) {
                localizedContentSB.append(sb);
            }
        }

        public void contributeToLocale(String locale, StringBundler sb) {
            this._contentSB.append(sb);
            StringBundler localizedContentSB = this._localizedContentSBMap.get(locale);
            if (localizedContentSB != null) {
                localizedContentSB.append(sb);
            }
        }

        public String getContent() {
            return this._contentSB.toString();
        }

        public Map<String, String> getLocalizedContentMap() {
            if (this._localizedContentSBMap.isEmpty()) {
                return Collections.emptyMap();
            }
            TreeMap<String, String> localizedContentMap = new TreeMap<String, String>();
            for (Map.Entry<String, StringBundler> localizedContentEntry : this._localizedContentSBMap.entrySet()) {
                StringBundler sb = localizedContentEntry.getValue();
                if (sb.index() <= 0) continue;
                localizedContentMap.put(localizedContentEntry.getKey(), sb.toString());
            }
            return localizedContentMap;
        }

        public void trim() {
            if (this._contentSB.index() > 0) {
                this._contentSB.setIndex(this._contentSB.index() - 1);
            }
            for (StringBundler localizedContentSB : this._localizedContentSBMap.values()) {
                if (localizedContentSB.index() <= 0) continue;
                localizedContentSB.setIndex(localizedContentSB.index() - 1);
            }
        }

        private ObjectContentHelper(boolean localizationEnabled, ObjectEntry objectEntry, List<ObjectField> objectFields, TextEmbeddingDocumentContributor textEmbeddingDocumentContributor) {
            this._contentSB = new StringBundler(objectFields.size());
            if (!localizationEnabled || !FeatureFlagManagerUtil.isEnabled((long)objectEntry.getCompanyId(), (String)"LPS-122920")) {
                return;
            }
            for (String languageId : textEmbeddingDocumentContributor.getLanguageIds((BaseModel)objectEntry)) {
                this._localizedContentSBMap.put(languageId, new StringBundler(objectFields.size() * 4));
            }
        }
    }
}

