/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.object.model.ObjectEntryFolder"}, service={ModelDocumentContributor.class})
public class ObjectEntryFolderModelDocumentContributor
implements ModelDocumentContributor<ObjectEntryFolder> {
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;

    public void contribute(Document document, ObjectEntryFolder objectEntryFolder) {
        document.addText("description", objectEntryFolder.getDescription());
        document.addKeyword("folderId", objectEntryFolder.getParentObjectEntryFolderId());
        document.addText("name", objectEntryFolder.getName());
        document.addKeyword("status", objectEntryFolder.getStatus());
        document.addText("title", objectEntryFolder.getName());
        String[] parts = StringUtil.split((String)objectEntryFolder.getTreePath(), (char)'/');
        document.addKeyword("treePath", parts);
        String cmsSection = this._getCMSSection(parts);
        if (cmsSection != null) {
            document.addKeyword("cms_kind", "folder");
            document.addKeyword("cms_root", parts.length == 3);
            document.addKeyword("cms_section", cmsSection);
        }
        document.addLocalizedKeyword("localized_label", objectEntryFolder.getLabelMap(), true, true);
    }

    private String _getCMSSection(String[] parts) {
        if (parts.length <= 2) {
            return null;
        }
        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.fetchObjectEntryFolder(GetterUtil.getLong((String)parts[1]));
        if (objectEntryFolder == null) {
            return null;
        }
        String externalReferenceCode = objectEntryFolder.getExternalReferenceCode();
        if (externalReferenceCode.equals("L_CONTENTS")) {
            return "contents";
        }
        if (externalReferenceCode.equals("L_FILES")) {
            return "files";
        }
        return null;
    }
}

