/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.object.internal.bulk.selection.ObjectBulkSelectionFactory;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.Map;

public class ObjectBulkSelection
implements BulkSelection<Object> {
    private final DepotEntryLocalService _depotEntryLocalService;
    private final ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final Map<String, String[]> _parameterMap;

    public ObjectBulkSelection(DepotEntryLocalService depotEntryLocalService, ObjectEntryFolderLocalService objectEntryFolderLocalService, ObjectEntryLocalService objectEntryLocalService, Map<String, String[]> parameterMap) {
        this._depotEntryLocalService = depotEntryLocalService;
        this._objectEntryFolderLocalService = objectEntryFolderLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._parameterMap = parameterMap;
    }

    public <E extends PortalException> void forEach(UnsafeConsumer<Object, E> unsafeConsumer) throws PortalException {
        for (String rowId : this._parameterMap.get("rowIds")) {
            String[] split = rowId.split(" ");
            if (split[0].equals(DepotEntry.class.getName())) {
                DepotEntry depotEntry = this._depotEntryLocalService.fetchGroupDepotEntry(GetterUtil.getLong((String)split[1]));
                if (depotEntry == null) {
                    depotEntry = this._depotEntryLocalService.getDepotEntry(GetterUtil.getLong((String)split[1]));
                }
                unsafeConsumer.accept((Object)depotEntry);
                continue;
            }
            if (split[0].equals(ObjectEntryFolder.class.getName())) {
                unsafeConsumer.accept((Object)this._objectEntryFolderLocalService.getObjectEntryFolder(GetterUtil.getLong((String)split[1])));
                continue;
            }
            unsafeConsumer.accept((Object)this._objectEntryLocalService.getObjectEntry(GetterUtil.getLong((String)split[1])));
        }
    }

    public Class<? extends BulkSelectionFactory> getBulkSelectionFactoryClass() {
        return ObjectBulkSelectionFactory.class;
    }

    public Map<String, String[]> getParameterMap() {
        return this._parameterMap;
    }

    public long getSize() {
        String[] rowIds = this._parameterMap.get("rowIds");
        return rowIds.length;
    }

    public Serializable serialize() {
        return StringUtil.merge((String[])this._parameterMap.get("rowIds"), (String)",");
    }

    public BulkSelection<AssetEntry> toAssetEntryBulkSelection() {
        throw new UnsupportedOperationException();
    }
}

