/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v7_0_0;

import com.liferay.object.internal.upgrade.v7_0_0.util.ObjectFolderTable;
import com.liferay.object.model.ObjectFolder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class ObjectDefinitionUpgradeProcess
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final ResourceLocalService _resourceLocalService;

    public ObjectDefinitionUpgradeProcess(CompanyLocalService companyLocalService, ResourceLocalService resourceLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompany(company -> this._addObjectFolder(company.getCompanyId(), company.getGuestUser()));
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{ObjectFolderTable.create(), UpgradeProcessFactory.addColumns((String)"ObjectDefinition", (String[])new String[]{"objectFolderId LONG"})};
    }

    private void _addObjectFolder(final long companyId, User user) throws PortalException, SQLException {
        PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"insert into ObjectFolder (uuid_, externalReferenceCode, ", "objectFolderId, companyId, userId, userName, createDate, ", "modifiedDate, label, name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?)"}));
        preparedStatement1.setString(1, PortalUUIDUtil.generate());
        preparedStatement1.setString(2, "uncategorized");
        long objectFolderId = this.increment();
        preparedStatement1.setLong(3, objectFolderId);
        preparedStatement1.setLong(4, companyId);
        preparedStatement1.setLong(5, user.getUserId());
        preparedStatement1.setString(6, user.getFullName());
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        preparedStatement1.setTimestamp(7, timestamp);
        preparedStatement1.setTimestamp(8, timestamp);
        preparedStatement1.setString(9, LocalizationUtil.getXml((LocalizedValuesMap)new LocalizedValuesMap(){
            {
                this.put(LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId)), "Uncategorized");
            }
        }, (String)"Label"));
        preparedStatement1.setString(10, "Uncategorized");
        preparedStatement1.execute();
        this._resourceLocalService.addResources(companyId, 0L, user.getUserId(), ObjectFolder.class.getName(), objectFolderId, false, true, true);
        PreparedStatement preparedStatement2 = this.connection.prepareStatement("update ObjectDefinition set objectFolderId = ? where companyId = ?");
        preparedStatement2.setLong(1, objectFolderId);
        preparedStatement2.setLong(2, companyId);
        preparedStatement2.execute();
    }
}

