/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v10_20_0;

import com.liferay.object.model.ObjectEntryTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;

public class ObjectFieldUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ObjectDefinition.objectDefinitionId, ", "ObjectDefinition.companyId, ObjectDefinition.userId, ", "ObjectDefinition.userName from ObjectDefinition where ", "ObjectDefinition.objectDefinitionId not in (select ", "distinct ObjectField.objectDefinitionId from ObjectField ", "where ObjectField.name in ('displaydate', ", "'expirationDate','reviewdate')) and ObjectDefinition.", "modifiable = [$TRUE$]"})));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into ObjectField (mvccVersion, uuid_, ", "externalReferenceCode, objectFieldId, companyId, ", "userId, userName, createDate, modifiedDate, ", "listTypeDefinitionId, objectDefinitionId, ", "businessType, dbColumnName, dbTableName, dbType, ", "indexed, indexedAsKeyword, indexedLanguageId, ", "label, localized, name, readOnly, ", "readOnlyConditionExpression, relationshipType,", "required, state_, system_) values (", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"}));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into ObjectFieldSetting (mvccVersion, uuid_, ", "objectFieldSettingId, companyId, userId, userName, ", "createDate, modifiedDate, objectFieldId, name, ", "value) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId));
                long objectDefinitionId = resultSet.getLong("objectDefinitionId");
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                this._insertObjectField(companyId, "display-date", defaultLocale, "displayDate", objectDefinitionId, preparedStatement2, preparedStatement3, timestamp, userId, userName);
                this._insertObjectField(companyId, "expiration-date", defaultLocale, "expirationDate", objectDefinitionId, preparedStatement2, preparedStatement3, timestamp, userId, userName);
                this._insertObjectField(companyId, "review-date", defaultLocale, "reviewDate", objectDefinitionId, preparedStatement2, preparedStatement3, timestamp, userId, userName);
                preparedStatement2.executeBatch();
                preparedStatement3.executeBatch();
            }
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"ObjectDefinition", (String[])new String[]{"enableObjectEntrySchedule BOOLEAN"})};
    }

    private void _insertObjectField(long companyId, final String key, final Locale locale, String name, long objectDefinitionId, PreparedStatement preparedStatement2, PreparedStatement preparedStatement3, Timestamp timestamp, long userId, String userName) throws SQLException {
        preparedStatement2.setLong(1, 0L);
        String uuid = PortalUUIDUtil.generate();
        preparedStatement2.setString(2, uuid);
        preparedStatement2.setString(3, uuid);
        long objectFieldId = this.increment();
        preparedStatement2.setLong(4, objectFieldId);
        preparedStatement2.setLong(5, companyId);
        preparedStatement2.setLong(6, userId);
        preparedStatement2.setString(7, userName);
        preparedStatement2.setTimestamp(8, timestamp);
        preparedStatement2.setTimestamp(9, timestamp);
        preparedStatement2.setLong(10, 0L);
        preparedStatement2.setLong(11, objectDefinitionId);
        preparedStatement2.setString(12, "DateTime");
        preparedStatement2.setString(13, name);
        preparedStatement2.setString(14, ObjectEntryTable.INSTANCE.getTableName());
        preparedStatement2.setString(15, "DateTime");
        preparedStatement2.setBoolean(16, false);
        preparedStatement2.setBoolean(17, false);
        preparedStatement2.setString(18, null);
        preparedStatement2.setString(19, LocalizationUtil.getXml((LocalizedValuesMap)new LocalizedValuesMap(){
            {
                this.put(locale, LanguageUtil.get((Locale)locale, (String)key));
            }
        }, (String)"Label"));
        preparedStatement2.setBoolean(20, false);
        preparedStatement2.setString(21, name);
        preparedStatement2.setBoolean(22, true);
        preparedStatement2.setString(23, null);
        preparedStatement2.setString(24, null);
        preparedStatement2.setBoolean(25, false);
        preparedStatement2.setBoolean(26, false);
        preparedStatement2.setBoolean(27, true);
        preparedStatement2.addBatch();
        preparedStatement3.setLong(1, 0L);
        preparedStatement3.setString(2, PortalUUIDUtil.generate());
        preparedStatement3.setLong(3, this.increment());
        preparedStatement3.setLong(4, companyId);
        preparedStatement3.setLong(5, userId);
        preparedStatement3.setString(6, userName);
        preparedStatement3.setTimestamp(7, timestamp);
        preparedStatement3.setTimestamp(8, timestamp);
        preparedStatement3.setLong(9, objectFieldId);
        preparedStatement3.setString(10, "timeStorage");
        preparedStatement3.setString(11, "convertToUTC");
        preparedStatement3.addBatch();
    }
}

