/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.ResourceActionModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.util.PortalInstances;
import java.util.Collection;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectFolderModelListener
extends BaseModelListener<ObjectFolder> {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFolderLocalService _objectFolderLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void onAfterCreate(ObjectFolder objectFolder) throws ModelListenerException {
        try {
            this._onAfterCreate(objectFolder);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    public void onAfterRemove(ObjectFolder objectFolder) throws ModelListenerException {
        if (PortalInstances.isCurrentCompanyInDeletionProcess()) {
            return;
        }
        try {
            ObjectFolder defaultObjectFolder = this._objectFolderLocalService.getDefaultObjectFolder(objectFolder.getCompanyId());
            for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getObjectFolderObjectDefinitions(objectFolder.getObjectFolderId())) {
                this._objectDefinitionLocalService.updateObjectFolderId(objectDefinition.getObjectDefinitionId(), defaultObjectFolder.getObjectFolderId());
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    public void onAfterUpdate(ObjectFolder originalObjectFolder, ObjectFolder objectFolder) throws ModelListenerException {
        try {
            for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getObjectFolderObjectDefinitions(objectFolder.getObjectFolderId())) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ObjectDefinition.class);
                indexer.reindex((Object)objectDefinition);
            }
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private Role _getOrAddCMSAdministratorRole(long companyId, long userId) throws Exception {
        Role role = this._roleLocalService.fetchRole(companyId, "CMS Administrator");
        if (role != null) {
            return role;
        }
        return this._roleLocalService.addRole(null, userId, null, 0L, "CMS Administrator", null, null, 1, null, null);
    }

    private void _onAfterCreate(ObjectFolder objectFolder) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)objectFolder.getCompanyId(), (String)"LPD-17564") || !Objects.equals(objectFolder.getExternalReferenceCode(), "L_CMS_CONTENT_STRUCTURES") && !Objects.equals(objectFolder.getExternalReferenceCode(), "L_CMS_FILE_TYPES")) {
            return;
        }
        Role cmsAdministratorRole = this._getOrAddCMSAdministratorRole(objectFolder.getCompanyId(), objectFolder.getUserId());
        this._resourcePermissionLocalService.setResourcePermissions(objectFolder.getCompanyId(), ObjectFolder.class.getName(), 4, String.valueOf(objectFolder.getObjectFolderId()), cmsAdministratorRole.getRoleId(), (String[])TransformUtil.transformToArray((Collection)this._resourceActionLocalService.getResourceActions(ObjectFolder.class.getName()), ResourceActionModel::getActionId, String.class));
    }
}

