/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.trigger.messaging;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.internal.entry.util.ObjectEntryUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/user_login"}, service={MessageListener.class})
public class ObjectActionUserLoginTriggerMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionUserLoginTriggerMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectActionEngine _objectActionEngine;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    private ServiceRegistration<Destination> _serviceRegistration;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("synchronous", "liferay/user_login");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        long companyId = message.getLong("companyId");
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(companyId, User.class.getName());
        if (objectDefinition == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Object definition is null for class name ", User.class.getName(), "and company ", companyId}));
            }
            return;
        }
        User user = this._userLocalService.getUser(message.getLong("userId"));
        this._objectActionEngine.executeObjectActions(objectDefinition.getClassName(), message.getLong("companyId"), "onAfterLogin", () -> ObjectEntryUtil.getPayloadJSONObject(user, this._dtoConverterRegistry, this._jsonFactory, "onAfterLogin", objectDefinition, null, this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName()), user.getUserId()), user.getUserId());
    }
}

